/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.bootifulcuneiforminterface.gui;

import net.minecraft.client.gui.GuiEditSign;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.common.block.tileentity.TileEntitySign;
import net.minecraft.common.util.ChatAllowedCharacters;
import net.minecraft.common.util.i18n.StringTranslate;
import net.tracystacktrace.bootifulcuneiforminterface.gui.InterfaceHelper;
import net.tracystacktrace.bootifulcuneiforminterface.mixins.AccessorGuiEditSign;

public class SignInterface
extends InterfaceHelper {
    public SignInterface(GuiEditSign screen) {
        super((GuiScreen)screen);
    }

    public void modifyOriginalDoneButton(int x, int y) {
        this.getButton((int)0).xPosition = x;
        this.getButton((int)0).yPosition = y;
        this.getButton((int)0).width = 32;
        this.getButton((int)0).height = 16;
        this.getButton((int)0).displayString = "\u00a7e\u270e";
        this.getButton((int)0).displayInfo = StringTranslate.getInstance().translateKey("bootifulcuneiforminterface.finish");
        this.getButton((int)0).canDisplayInfo = true;
    }

    @Override
    protected void setText(String text) {
        if (text.isEmpty()) {
            for (int i = 0; i < 4; ++i) {
                this.getEntitySign().signText[i] = "";
            }
            return;
        }
        String limited = text.length() > 60 ? text.substring(0, 60) : text;
        for (int i = 0; i < 4; ++i) {
            int start = i * 15;
            this.getEntitySign().signText[i] = limited.substring(start, Math.min(start + 15, limited.length()));
        }
    }

    @Override
    protected void appendText(String text) {
        if (text.isEmpty()) {
            return;
        }
        String[] textArray = this.getEntitySign().signText;
        for (char c : text.toCharArray()) {
            if (!ChatAllowedCharacters.isAllowedCharacter((char)c) || textArray[this.getEditLine()].length() >= 15) continue;
            textArray[this.getEditLine()] = textArray[this.getEditLine()] + c;
        }
    }

    @Override
    protected String getText() {
        return this.getEntitySign().signText[this.getEditLine()];
    }

    @Override
    protected void finishWriting() {
        this.getEntitySign().updateTileEntityIThink();
    }

    private int getEditLine() {
        return ((AccessorGuiEditSign)this.screen).bci$getEditLine();
    }

    private TileEntitySign getEntitySign() {
        return ((AccessorGuiEditSign)this.screen).bci$getEntitySign();
    }
}

