/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting;

import com.snackpirate.constructscasting.fluids.CCFluids;
import com.snackpirate.constructscasting.items.CCItems;
import com.snackpirate.constructscasting.items.ModifiableSpellbookRenderer;
import com.snackpirate.constructscasting.modifiers.CCModifiers;
import com.snackpirate.constructscasting.spells.CCEntities;
import com.snackpirate.constructscasting.spells.slime.slimeball.SlimeballProjectileRenderer;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.util.ConstantFluidContainerWrapper;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.tools.logic.ModifierEvents;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(modid="constructs_casting", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CCEvents {
    private static final String SOULBOUND_SLOT = "tic_soulbound_slot";

    @SubscribeEvent
    static void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        CCEvents.itemPouring(event, stack, (Item)ItemRegistry.LIGHTNING_BOTTLE.get(), CCFluids.liquidLightning, 250, Items.f_42590_.m_7968_());
        CCEvents.itemPouring(event, stack, (Item)ItemRegistry.INK_COMMON.get(), CCFluids.commonInk, 250, Items.f_42590_.m_7968_());
        CCEvents.itemPouring(event, stack, (Item)ItemRegistry.INK_UNCOMMON.get(), CCFluids.uncommonInk, 250, Items.f_42590_.m_7968_());
        CCEvents.itemPouring(event, stack, (Item)ItemRegistry.INK_RARE.get(), CCFluids.rareInk, 250, Items.f_42590_.m_7968_());
        CCEvents.itemPouring(event, stack, (Item)ItemRegistry.INK_EPIC.get(), CCFluids.epicInk, 250, Items.f_42590_.m_7968_());
        CCEvents.itemPouring(event, stack, (Item)ItemRegistry.INK_LEGENDARY.get(), CCFluids.legendaryInk, 250, Items.f_42590_.m_7968_());
    }

    public static void itemPouring(AttachCapabilitiesEvent<ItemStack> event, ItemStack itemStack, Item input, FluidObject<? extends Fluid> fluidObject, int amount, ItemStack output) {
        if (itemStack.m_41720_().equals(input)) {
            event.addCapability(fluidObject.getId(), (ICapabilityProvider)new ConstantFluidContainerWrapper(new FluidStack(fluidObject.get(), amount), itemStack, output));
        }
    }

    @SubscribeEvent
    static void enderferenceAntiSpell(SpellPreCastEvent event) {
        String spellId;
        Player entity = event.getEntity();
        if (entity.m_21023_((MobEffect)TinkerEffects.enderference.get()) && ((spellId = event.getSpellId()).equals("irons_spellbooks:teleport") || spellId.equals("irons_spellbooks:blood_step") || spellId.equals("irons_spellbooks:frost_step"))) {
            entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 2.0f, 0.2f + Utils.random.m_188501_() * 0.2f);
            entity.m_5661_((Component)Component.m_237115_((String)"ui.constructs_casting.enderference_anti_teleport").m_130940_(ChatFormatting.RED), true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void soulboundSpellbookDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player && !((player = (Player)entity) instanceof FakePlayer)) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                ItemStack spellbook = ((ICurioStacksHandler)handler.getCurios().get("spellbook")).getStacks().getStackInSlot(0);
                if (!spellbook.m_41619_() && ModifierUtil.checkVolatileFlag((ItemStack)spellbook, (ResourceLocation)ModifierEvents.SOULBOUND)) {
                    spellbook.m_41784_().m_128405_(SOULBOUND_SLOT, 999);
                }
            });
        }
    }

    @SubscribeEvent
    static void soulboundSpellbookDrop(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player) {
            Player player = (Player)entity;
            if (!(entity instanceof FakePlayer)) {
                Collection drops = event.getDrops();
                Iterator iter = drops.iterator();
                while (iter.hasNext()) {
                    int slot;
                    ItemEntity itemEntity = (ItemEntity)iter.next();
                    ItemStack stack = itemEntity.m_32055_();
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null || !tag.m_128425_(SOULBOUND_SLOT, 99) || (slot = tag.m_128451_(SOULBOUND_SLOT)) != 999) continue;
                    CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.setEquippedCurio("spellbook", 0, stack));
                    iter.remove();
                }
            }
        }
    }

    @SubscribeEvent
    static void soulboundSpellbookClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        if (clone.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) || original.m_5833_()) {
            return;
        }
        LazyOptional originalInv = CuriosApi.getCuriosInventory((LivingEntity)original);
        LazyOptional cloneInv = CuriosApi.getCuriosInventory((LivingEntity)clone);
        originalInv.ifPresent(handler -> handler.findCurio("spellbook", 0).ifPresent(slotResult -> {
            CompoundTag tag;
            ItemStack stack = slotResult.stack();
            if (!stack.m_41619_() && (tag = stack.m_41783_()) != null && tag.m_128425_(SOULBOUND_SLOT, 99)) {
                cloneInv.ifPresent(handler2 -> handler2.setEquippedCurio("spellbook", 0, stack));
                tag.m_128473_(SOULBOUND_SLOT);
                if (tag.m_128456_()) {
                    stack.m_41751_(null);
                }
            }
        }));
    }

    @Mod.EventBusSubscriber(modid="constructs_casting", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModClientEvents {
        @SubscribeEvent
        static void registerCurioRenderers(FMLClientSetupEvent e) {
            CuriosRendererRegistry.register((Item)((Item)CCItems.travellersSpellbook.get()), ModifiableSpellbookRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)CCItems.slimySpellbook.get()), ModifiableSpellbookRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)CCItems.platedSpellbook.get()), ModifiableSpellbookRenderer::new);
        }

        @SubscribeEvent
        static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)CCEntities.SLIMEBALL_PROJECTILE.get(), SlimeballProjectileRenderer::new);
        }
    }

    @Mod.EventBusSubscriber(modid="constructs_casting", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeClientEvents {
        @SubscribeEvent
        static void swiftcastingHandleInput(MovementInputUpdateEvent event) {
            if (ClientMagicData.isCasting() && ModifierUtil.getModifierLevel((ItemStack)event.getEntity().m_21120_(InteractionHand.MAIN_HAND), (ModifierId)CCModifiers.SWIFTCASTING) > 0) {
                event.getInput().f_108566_ *= 5.0f;
                event.getInput().f_108567_ *= 5.0f;
            }
        }
    }
}

