/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting;

import com.mojang.logging.LogUtils;
import com.snackpirate.constructscasting.CCDamageTypes;
import com.snackpirate.constructscasting.CCLang;
import com.snackpirate.constructscasting.CCSounds;
import com.snackpirate.constructscasting.fluids.CCFluidEffects;
import com.snackpirate.constructscasting.fluids.CCFluids;
import com.snackpirate.constructscasting.items.CCItems;
import com.snackpirate.constructscasting.items.CCToolSpriteProvider;
import com.snackpirate.constructscasting.items.CCTools;
import com.snackpirate.constructscasting.items.ModifiableSpellbookItem;
import com.snackpirate.constructscasting.materials.CCMaterialStats;
import com.snackpirate.constructscasting.materials.CCMaterialTextures;
import com.snackpirate.constructscasting.materials.CCMaterials;
import com.snackpirate.constructscasting.materials.CCToolStats;
import com.snackpirate.constructscasting.materials.MagicBaseMaterialStats;
import com.snackpirate.constructscasting.materials.MagicClothMaterialStats;
import com.snackpirate.constructscasting.modifiers.BonusCurioSlotModule;
import com.snackpirate.constructscasting.modifiers.CCModifiers;
import com.snackpirate.constructscasting.modifiers.SpellbookStrapModule;
import com.snackpirate.constructscasting.modifiers.hooks.CCModifierHooks;
import com.snackpirate.constructscasting.recipe.CCRecipes;
import com.snackpirate.constructscasting.recipe.CCSlotLayoutProvider;
import com.snackpirate.constructscasting.spells.CCEntities;
import com.snackpirate.constructscasting.spells.CCSpells;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.mantle.registration.deferred.SynchronizedDeferredRegister;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.GeneratorPartTextureJsonGenerator;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.tools.data.sprite.TinkerMaterialSpriteProvider;
import slimeknights.tconstruct.tools.data.sprite.TinkerPartSpriteProvider;

@Mod(value="constructs_casting")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConstructsCasting {
    public static final String MOD_ID = "constructs_casting";
    protected static final SynchronizedDeferredRegister<CreativeModeTab> CREATIVE_TABS = SynchronizedDeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"constructs_casting");
    public static final RegistryObject<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("main", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.constructs_casting.constructs_casting")).m_257737_(() -> ((ModifiableSpellbookItem)CCItems.platedSpellbook.get()).getRenderTool()).m_257501_(CCItems::addTabItems).m_257652_());
    public static final Logger LOGGER = LogUtils.getLogger();

    public ConstructsCasting() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerSerializers);
        MinecraftForge.EVENT_BUS.register((Object)this);
        CCModifiers.MODIFIERS.register(modEventBus);
        CCFluids.FLUIDS.register(modEventBus);
        CCFluidEffects.MobEffects.register(modEventBus);
        CCItems.ITEMS.register(modEventBus);
        CCRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        CCSounds.register(modEventBus);
        CCEntities.register(modEventBus);
        CCSpells.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        modEventBus.register((Object)new CCFluids());
    }

    public static ResourceLocation id(String name) {
        return ResourceLocation.m_214293_((String)MOD_ID, (String)name);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CCModifierHooks.init();
        MaterialRegistry.getInstance().registerStatType(MagicBaseMaterialStats.TYPE, CCToolStats.MAGIC);
        MaterialRegistry.getInstance().registerStatType(MagicClothMaterialStats.TYPE, CCToolStats.MAGIC);
        MaterialRegistry.getInstance().registerStatType(CCMaterialStats.Statless.ADORNMENT.getType());
        NBTKeyModel.registerExtraTexture((ResourceLocation)TConstruct.getResource((String)"creative_slot"), (String)"affinity", (ResourceLocation)ConstructsCasting.id("gui/modifiers/affinity_slot"));
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        boolean server = event.includeServer();
        PackOutput output = gen.getPackOutput();
        CCMaterials mats = new CCMaterials(output);
        gen.addProvider(server, (DataProvider)mats);
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture provider = event.getLookupProvider();
        gen.addProvider(server, (DataProvider)new CCTools.CCToolDefinitions(output, MOD_ID));
        gen.addProvider(server, (DataProvider)new CCMaterials.MaterialStats(output, mats));
        gen.addProvider(server, (DataProvider)new CCMaterials.CCMaterialRenderInfo(output, new CCMaterialTextures(), fileHelper));
        gen.addProvider(server, (DataProvider)new CCModifiers(output));
        gen.addProvider(server, (DataProvider)new CCMaterials.CCMaterialTraits(output, mats));
        gen.addProvider(server, (DataProvider)new MaterialPartTextureGenerator(output, fileHelper, (AbstractPartSpriteProvider)new TinkerPartSpriteProvider(), new AbstractMaterialSpriteProvider[]{new CCMaterialTextures()}));
        gen.addProvider(server, (DataProvider)new MaterialPartTextureGenerator(output, fileHelper, (AbstractPartSpriteProvider)new CCToolSpriteProvider(MOD_ID), ConstructsCasting.getOverride(), new AbstractMaterialSpriteProvider[]{new CCMaterialTextures(), new TinkerMaterialSpriteProvider()}));
        gen.addProvider(server, (DataProvider)new CCSlotLayoutProvider(output));
        gen.addProvider(server, (DataProvider)new CCItems.Tags(output, provider, CompletableFuture.completedFuture(TagsProvider.TagLookup.m_274566_()), MOD_ID, fileHelper));
        gen.addProvider(server, (DataProvider)new CCFluids.CCFluidTextures(output, MOD_ID));
        gen.addProvider(server, (DataProvider)new CCFluids.CCBucketModels(output, MOD_ID));
        gen.addProvider(server, (DataProvider)new CCFluids.Tags(output, provider, MOD_ID, fileHelper));
        gen.addProvider(server, (DataProvider)new CCFluids.Tags.CCFluidTooltipProvider(output, MOD_ID));
        gen.addProvider(server, (DataProvider)new CCRecipes(output));
        gen.addProvider(server, (DataProvider)new CCFluidEffects(output, MOD_ID));
        gen.addProvider(server, (DataProvider)new CCLang(output, MOD_ID, "en_us"));
        gen.addProvider(server, (DataProvider)new CCDamageTypes.Tags(output, provider, MOD_ID, fileHelper));
        gen.addProvider(server, (DataProvider)new CCModifiers.Tags(output, MOD_ID, fileHelper));
    }

    private static GeneratorPartTextureJsonGenerator.StatOverride getOverride() {
        GeneratorPartTextureJsonGenerator.StatOverride.Builder builder = new GeneratorPartTextureJsonGenerator.StatOverride.Builder();
        CCMaterials.tinkerClothMaterials.forEach(material -> builder.add(MagicClothMaterialStats.ID, (ResourceLocation)material.getId()));
        CCMaterials.tinkerMagicMaterials.forEach(material -> builder.add(MagicBaseMaterialStats.ID, (ResourceLocation)material.getId()));
        return builder.build();
    }

    void registerSerializers(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256764_) {
            ModifierModule.LOADER.register(ConstructsCasting.id("spellbook_strap"), SpellbookStrapModule.LOADER);
            ModifierModule.LOADER.register(ConstructsCasting.id("bonus_curio_slots"), BonusCurioSlotModule.LOADER);
        }
    }
}

