/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.materials;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.snackpirate.constructscasting.ConstructsCasting;
import com.snackpirate.constructscasting.materials.CCToolStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public record MagicClothMaterialStats(float spellSlots, float cooldownReduction) implements IMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(ConstructsCasting.id("magic_cloth"));
    public static final MaterialStatType<MagicClothMaterialStats> TYPE = new MaterialStatType(ID, (IMaterialStats)new MagicClothMaterialStats(0.0f, 0.0f), RecordLoadable.create((RecordField)FloatLoadable.ANY.defaultField("spell_slots", (Object)Float.valueOf(0.0f), true, MagicClothMaterialStats::spellSlots), (RecordField)FloatLoadable.ANY.defaultField("cooldown_reduction", (Object)Float.valueOf(0.0f), true, MagicClothMaterialStats::cooldownReduction), MagicClothMaterialStats::new));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)CCToolStats.SPELL_SLOTS.getDescription(), (Object)CCToolStats.COOLDOWN_REDUCTION.getDescription());

    public MaterialStatType<?> getType() {
        return TYPE;
    }

    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(IToolStat.formatNumber((String)IMaterialStats.makeTooltipKey((ResourceLocation)ConstructsCasting.id("spell_slots")), (TextColor)TextColor.m_131266_((int)5569788), (float)this.spellSlots));
        info.add(IToolStat.formatColoredPercentBoost((String)IMaterialStats.makeTooltipKey((ResourceLocation)ConstructsCasting.id("cooldown_reduction")), (float)this.cooldownReduction));
        return info;
    }

    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public void apply(ModifierStatsBuilder builder, float scale) {
        CCToolStats.SPELL_SLOTS.update(builder, Float.valueOf(this.spellSlots * scale));
        CCToolStats.COOLDOWN_REDUCTION.update(builder, Float.valueOf(this.cooldownReduction * scale));
    }
}

