/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.modifiers;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.utils.Util;

public class AntimagicModifier
extends Modifier
implements MeleeDamageModifierHook,
TooltipModifierHook,
ProjectileHitModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_DAMAGE, ModifierHooks.TOOLTIP, ModifierHooks.PROJECTILE_HIT);
        super.registerHooks(hookBuilder);
    }

    public float getMeleeDamage(IToolStackView iToolStackView, ModifierEntry modifierEntry, ToolAttackContext toolAttackContext, float v, float v1) {
        int level = modifierEntry.getLevel();
        float damageBonus = AntimagicModifier.isMagicUser(toolAttackContext.getLivingTarget()) ? 2.0f * (float)level : 0.0f;
        return v1 + damageBonus;
    }

    public void addTooltip(IToolStackView iToolStackView, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        int damageBoost = 2 * modifierEntry.getLevel();
        list.add((Component)this.applyStyle(Component.m_237113_((String)(Util.BONUS_FORMAT.format(damageBoost) + " ")).m_7220_((Component)Component.m_237115_((String)"modifier.constructs_casting.antimagic.damage_boost"))));
    }

    private static boolean isMagicUser(LivingEntity target) {
        return MagicData.getPlayerMagicData((LivingEntity)target).isCasting() || target instanceof AbstractSpellCastingMob || target instanceof MagicSummon || MagicData.getPlayerMagicData((LivingEntity)target).getMana() > 101.0f;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (target != null && AntimagicModifier.isMagicUser(target) && projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            arrow.m_36781_(arrow.m_36789_() + (double)((float)modifier.getLevel() / 2.0f));
        }
        return false;
    }
}

