/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.modifiers;

import com.snackpirate.constructscasting.items.CCItems;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.SingleLevelModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public class SolarChargedModifier
extends SingleLevelModifier
implements EquipmentChangeModifierHook,
TooltipModifierHook,
InventoryTickModifierHook {
    private static final UUID uuid = UUID.nameUUIDFromBytes("attribute.constructs_casting.solar_charged".getBytes());
    private static final int minLight = 5;
    private static final float amount = 0.15f;

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.EQUIPMENT_CHANGE);
        hookBuilder.addHook((Object)this, ModifierHooks.TOOLTIP);
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK);
    }

    private int getLight(Level level, BlockPos pos) {
        return level.m_45517_(LightLayer.SKY, pos);
    }

    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        float boost;
        if (!tool.hasTag(CCItems.Tags.MAGIC_TOOL)) {
            return;
        }
        int light = 15;
        if (player != null && key == TooltipKey.SHIFT) {
            light = this.getLight(player.m_9236_(), player.m_20183_());
        }
        if ((boost = 0.15f * (float)(light - 5) * entry.getEffectiveLevel() / 10.0f) > 0.0f) {
            tooltip.add((Component)this.applyStyle(Component.m_237113_((String)(Util.PERCENT_BOOST_FORMAT.format(boost) + " ")).m_7220_((Component)Component.m_237115_((String)"modifier.constructs_casting.solar_charged.boost"))));
        }
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity living, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        Level level = living.m_9236_();
        if (level.f_46443_) {
            return;
        }
        AttributeInstance attribute = living.m_21051_((Attribute)AttributeRegistry.MANA_REGEN.get());
        if (attribute == null) {
            return;
        }
        if (attribute.m_22111_(uuid) != null) {
            attribute.m_22120_(uuid);
        }
        Vec3 vecPos = living.m_20182_();
        BlockPos pos = BlockPos.m_274561_((double)vecPos.f_82479_, (double)(vecPos.f_82480_ + 0.5), (double)vecPos.f_82481_);
        int light = this.getLight(level, pos);
        if (light > 5) {
            int scaledLight = light - 5;
            attribute.m_22118_(new AttributeModifier(uuid, "attribute.constructs_casting.solar_charged", (double)((float)scaledLight * 0.15f * modifier.getEffectiveLevel() / 10.0f), AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        super.onEquip(tool, modifier, context);
    }

    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        AttributeInstance attribute;
        IToolStackView newTool;
        LivingEntity livingEntity = context.getEntity();
        if (context.getChangedSlot() == EquipmentSlot.LEGS && ((newTool = context.getReplacementTool()) == null || newTool.getModifier(modifier.getId()).getEffectiveLevel() != modifier.getEffectiveLevel()) && (attribute = livingEntity.m_21051_((Attribute)AttributeRegistry.MANA_REGEN.get())) != null && attribute.m_22111_(uuid) != null) {
            attribute.m_22120_(uuid);
        }
    }
}

