/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.modifiers;

import com.snackpirate.constructscasting.ConstructsCasting;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class SpellSlotsModifier
extends Modifier
implements ValidateModifierHook,
InventoryTickModifierHook {
    public static final String TAG_HAS_SPELLS = "spell_slots_active";

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.VALIDATE, ModifierHooks.INVENTORY_TICK);
    }

    public boolean shouldDisplay(boolean advanced) {
        return false;
    }

    @Nullable
    public Component validate(IToolStackView tool, ModifierEntry modifier) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(ConstructsCasting.id(TAG_HAS_SPELLS)) && persistentData.getBoolean(ConstructsCasting.id(TAG_HAS_SPELLS))) {
            return Component.m_237115_((String)"ui.constructs_casting.spellbook_has_slots");
        }
        return null;
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (world.m_46467_() % 10L != 0L) {
            return;
        }
        ISpellContainer container = ISpellContainer.get((ItemStack)stack);
        ModDataNBT persistentData = tool.getPersistentData();
        persistentData.putBoolean(ConstructsCasting.id(TAG_HAS_SPELLS), !container.isEmpty());
    }
}

