/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting;

import com.snackpirate.constructscasting.fluids.CCFluidEffects;
import com.snackpirate.constructscasting.fluids.CCFluids;
import com.snackpirate.constructscasting.items.CCItems;
import com.snackpirate.constructscasting.materials.CCMaterials;
import com.snackpirate.constructscasting.modifiers.CCModifiers;
import com.snackpirate.constructscasting.spells.CCSpells;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public class CCLang
extends LanguageProvider {
    public CCLang(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
    }

    protected void addTranslations() {
        this.add("itemGroup.constructs_casting.constructs_casting", "Construct's Casting");
        this.addMaterial(CCMaterials.arcanium, "Arcanium", "Yer a wizard, Harry!", "Gives the wielder +25 max mana per part.");
        this.addMaterial(CCMaterials.exilite, "Exilite", "#1 Wizard Hater", "Deals greater damage to magic-wielding enemies.");
        this.addMaterial(CCMaterials.arcaneCloth, "Arcane Cloth", "Mage essential!", "Empowers the wielder with greater spell power.");
        this.addMaterial(CCMaterials.frozenBone, "Frozen Bone", "Ice, ice, baby", "Deals greater damage to frozen enemies");
        this.addMaterial(CCMaterials.frostRod, "Frosted", "Cold, cold heart", "Empowers ice-based magic");
        this.addMaterial(CCMaterials.paper, "Paper", "Simple but effective", "No special ability, but has a lot of spell slots");
        this.addMaterial(CCMaterials.leaf, "Leaf", "Time to make like a tree...", "Like all plants, it becomes more powerful in sunlight.");
        this.addMaterial(CCMaterials.hogskin, "Hogskin", "Unsanitary, but still useful", "The skin adapts to its environment, providing different buffs depending on the temperature");
        this.addMaterial(CCMaterials.dragonskin, "Dragonskin", "How to read your dragon", "The might of the dragon empowers your magic while in flight.");
        this.addMaterial(CCMaterials.amethyst, "Amethyst", "They're minerals, Marie!", "Helps you cast spells faster");
        this.addMaterial(CCMaterials.permafrost, "Permafrost", "Not to be confused with permafrost", "Empowers ice magic");
        this.addMaterial(CCMaterials.quartz, "Nether Quartz", "Silicon dioxide", "Empowers fire magic");
        this.addMaterial(CCMaterials.glowstone, "Glowstone", "Shines bright, but not like a diamond", "Empowers holy magic");
        this.addMaterial(CCMaterials.earthslimeCrystal, "Earthslime", "Earthen where?", "Empowers nature magic");
        this.addMaterial(CCMaterials.skyslimeCrystal, "Skyslime", "Skyward slime", "Empowers lightning magic");
        this.addMaterial(CCMaterials.emerald, "Emerald", "Villagers hate this simple trick", "Empowers evocation magic");
        this.addMaterial(CCMaterials.enderslimeCrystal, "Enderslime", "Smells like grape", "Empowers ender magic");
        this.addMaterial(CCMaterials.ichorCrystal, "Ichor", "I hardly know her", "Empowers blood magic");
        this.addMaterial(CCMaterials.echoShard, "Echo", "Echo", "Empowers eldritch magic");
        this.add("stat.constructs_casting.magic_cloth", "Pages");
        this.add("stat.constructs_casting.magic_base", "Base");
        this.add("tool_stat.constructs_casting.spell_slots", "Spell Slots: ");
        this.add("tool_stat.constructs_casting.spell_slots.description", "How many spells this spellbook can have.");
        this.add("tool_stat.constructs_casting.cooldown_reduction", "Cooldown Reduction: ");
        this.add("tool_stat.constructs_casting.cooldown_reduction.description", "Increases how often you can cast spells when equipped.");
        this.add("tool_stat.constructs_casting.max_mana", "Max Mana: ");
        this.add("tool_stat.constructs_casting.max_mana.description", "Tool grants this much maximum mana when equipped.");
        this.add("tool_stat.constructs_casting.spell_power", "Spell Power: ");
        this.add("tool_stat.constructs_casting.spell_power.description", "Increases the power of your spells when equipped.");
        this.add("stat.constructs_casting.spellbook_plating", "Plating");
        this.add("stat.constructs_casting.adornment", "Adornment");
        this.add("pattern.constructs_casting.spellbook_plating", "Spellbook Plating");
        this.add("pattern.constructs_casting.faceted_gem", "Faceted Gem");
        this.add("pattern.constructs_casting.spellbook_cover", "Spellbook Cover");
        this.add("pattern.constructs_casting.wand_rod", "Wand Rod");
        this.add("pattern.constructs_casting.pages", "Pages");
        this.add("pattern.constructs_casting.spellbooks", "Spellbooks");
        this.add("pattern.constructs_casting.spellbooks_first_part", "Spellbook Plating or Cover");
        this.add("pattern.constructs_casting.spellbooks.description", "Used to hold and cast spells. Use a Spellbook Plating for the Plated Spellbook, or a Spellbook Cover for the Traveller's Spellbook.");
        this.add("tool_stat.constructs_casting.extra.no_stats", "No stats");
        this.add("material.constructs_casting.exilite.armor", "Protects against damage inflicted by spells.");
        this.addMaterial(CCMaterials.rainbowSlime, "Rainbowslime", "How are you seeing this?", "Happy pride month!");
        this.addModifier(CCModifiers.CASTING.getId(), "Casting", "Not for fish, unfortunately.", "Allows the tool to cast spells on right click.");
        this.addModifier(CCModifiers.SWIFTCASTING, "Swiftcasting", "Run 'n' Gun!", "Allows the user to retain their full movement speed while casting spells.");
        this.addModifier(CCModifiers.SPELLBLADE.getId(), "Spellblade", "Strike!", "Hitting an enemy casts the spell imbued on the tool.");
        this.addMaterial(CCMaterials.cosmichalcum, "Cosmichalcum", "Template flavor text", "Template description");
        this.add("constructs_casting.modifier.swiftcasting.requirement", "Requires the Casting ability to be applied first.");
        this.addModifier(CCModifiers.IMBUED.getId(), "Imbued", "One more spell!", "Allows the tool to be imbued with a spell.");
        this.addModifier(CCModifiers.ENCYCLOPEDIC.getId(), "Encyclopedic", "Well read", "Allows the Spellbook to function as an encyclopedia on right click.");
        this.addModifier(CCModifiers.ARCANE, "Arcane", "Mana-licious!", "Grants +25 max mana.");
        this.addModifier(CCModifiers.ANTIMAGIC.getId(), "Antimagic", "Self-explanatory.", "Grants +2 damage against magic users.");
        this.add("modifier.constructs_casting.antimagic.damage_boost", "Antimagic Damage");
        this.addModifier(CCModifiers.SPELL_PROTECTION, "Spell Protection", "Diabolical!", "Grants +10% resistance against spells. (Different from Magic Protection)");
        this.add("modifier.constructs_casting.spell_protection.resistance", "Spell Resistance");
        this.addModifier(CCModifiers.ANTIFROST, "Antifrost", "Don't drink it!", "Grants +3 damage per level to frozen targets.");
        this.add("modifier.constructs_casting.antifrost.attack_damage", "Antifrost Damage");
        this.addModifier(CCModifiers.SPELLBOUND, "Spellbound", "Jack of all trades!", "Grants +5% power to all types of spells.");
        this.addModifier(CCModifiers.SPELLBOOK_STRAP.getId(), "Spellbook Strap", "Twice the spells, twice the fun!", "Interacting with the leggings allows swapping your spellbook with another one in the leggings' inventory.");
        this.addModifier(CCModifiers.MANA_UPGRADE, "Mana Upgrade", "Mana-rific!", "Grants +80 max mana.");
        this.addModifier(CCModifiers.COOLDOWN_UPGRADE, "Cooldown Upgrade", "I am speed!", "Grants +5% Cooldown Reduction.");
        this.addModifier(CCModifiers.FIRE_UPGRADE, "Fire Upgrade", "Hot hot hot!", "Grants +5% Fire Spell Power.");
        this.addModifier(CCModifiers.ICE_UPGRADE, "Ice Upgrade", "Ice ice baby!", "Grants +5% Ice Spell Power.");
        this.addModifier(CCModifiers.LIGHTNING_UPGRADE, "Lightning Upgrade", "Electrifying!", "Grants +5% Lightning Spell Power.");
        this.addModifier(CCModifiers.ENDER_UPGRADE, "Ender Upgrade", "Space-y!", "Grants +5% Ender Spell Power.");
        this.addModifier(CCModifiers.HOLY_UPGRADE, "Holy Upgrade", "Great heavens!", "Grants +5% Holy Spell Power.");
        this.addModifier(CCModifiers.BLOOD_UPGRADE, "Blood Upgrade", "Bloody hell!", "Grants +5% Blood Spell Power.");
        this.addModifier(CCModifiers.EVOCATION_UPGRADE, "Evocation Upgrade", "Hrmmm?", "Grants +5% Evocation Spell Power.");
        this.addModifier(CCModifiers.NATURE_UPGRADE, "Nature Upgrade", "All natural!", "Grants +5% Nature Spell Power.");
        this.addModifier(CCModifiers.ELDRITCH_UPGRADE, "Eldritch Upgrade", "Man-made modifiers beyond your comprehension", "Grants +5% Eldritch Spell Power");
        this.addModifier(CCModifiers.ABYSSAL_UPGRADE, "Abyssal Upgrade", "Not to be confused with Aqua", "Grants +5% Abyssal Spell Power.");
        this.addModifier(CCModifiers.TECHNOMANCY_UPGRADE, "Technomancy Upgrade", "Hackerman", "Grants +5% Technomancy Spell Power.");
        this.addModifier(CCModifiers.AQUA_UPGRADE, "Aqua Upgrade", "Not to be confused with Abyssal", "Grants +5% Aqua Spell Power.");
        this.addModifier(CCModifiers.SPELL_DISPULSION, "Spell Dispulsion", "Not to be confused with Spell Protection", "Grants +7.5% Spell Resistance");
        this.addModifier(CCModifiers.FIRE_DISPULSION, "Fire Dispulsion", "The power of the sun in the palm of my hand", "Grants +15% Fire Spell Resistance.");
        this.addModifier(CCModifiers.ICE_DISPULSION, "Ice Dispulsion", "Ice to meet you", "Grants +15% Ice Spell Resistance.");
        this.addModifier(CCModifiers.LIGHTNING_DISPULSION, "Lightning Dispulsion", "Surge protection", "Grants +15% Lightning Spell Resistance.");
        this.addModifier(CCModifiers.ENDER_DISPULSION, "Ender Dispulsion", "Take that, globeheads!", "Grants +15% Ender Spell Resistance.");
        this.addModifier(CCModifiers.HOLY_DISPULSION, "Holy Dispulsion", "Neither the power of god nor anime", "Grants +15% Holy Spell Resistance.");
        this.addModifier(CCModifiers.BLOOD_DISPULSION, "Blood Dispulsion", "Dirty haemophiles", "Grants +15% Blood Spell Resistance.");
        this.addModifier(CCModifiers.EVOCATION_DISPULSION, "Evocation Dispulsion", "Hrmmm!", "Grants +15% Evocation Spell Resistance.");
        this.addModifier(CCModifiers.NATURE_DISPULSION, "Nature Dispulsion", "Insert allegory for AI here", "Grants +15% Nature Spell Resistance.");
        this.addModifier(CCModifiers.ELDRITCH_DISPULSION, "Eldritch Dispulsion", "Comprehending horrors", "Grants +15% Eldritch Spell Resistance.");
        this.addFluid(CCFluids.arcaneEssence, "Arcane Essence", "Probably tastes like blue raspberry; good if you're short on Mana though.");
        this.addFluid(CCFluids.fireEssence, "Fire Essence", "Subtle notes of sulfur with an ashy aftertaste; Good if you need a little more FIREpower");
        this.addFluid(CCFluids.iceEssence, "Ice Essence", "The active ingredient in Gatorade Frost; useful if you want to chill out");
        this.addFluid(CCFluids.lightningEssence, "Lightning Essence", "The closest thing to battery acid you can still drink; Electromancers love it");
        this.addFluid(CCFluids.enderEssence, "Ender Essence", "You'll have to stomach the grape flavoring, but Shadow-Walkers love it!");
        this.addFluid(CCFluids.holyEssence, "Holy Essence", "Helpful for those who wish to boost their healing magic");
        this.addFluid(CCFluids.bloodEssence, "Blood Essence", "Questionably ethical, but Cultists drink it every day");
        this.addFluid(CCFluids.evocationEssence, "Evocation Essence", "Empowers evocation magic");
        this.addFluid(CCFluids.natureEssence, "Nature Essence", "Still smells moldy; but it empowers nature magic");
        this.addFluid(CCFluids.cinderEssence, "Cinder Essence", "From inferno to fork; leaches mana from your enemies");
        this.addFluid(CCFluids.liquidLightning, "Lightning", "");
        this.addFluid((FluidObject<?>)CCFluids.potatoStew, "Potato Stew", "A vegan yet still hearty alternative to Meat Soup");
        this.addFluid((FluidObject<?>)CCFluids.poisonousPotatoStew, "Poisonous Potato Stew", "A vegan yet still devastating alternative to spider venom");
        this.addFluid((FluidObject<?>)CCFluids.moltenArcanium, "Molten Arcanium", "Definitely tastes like blue raspberry; good for any sort of magic");
        this.addFluid((FluidObject<?>)CCFluids.moltenExilite, "Molten Exilite", "Most effective against mages and other magic users.");
        this.addFluid((FluidObject<?>)CCFluids.moltenArcaneSalvage, "Molten Arcane Salvage", "Allows you to cast spells faster");
        this.addFluid(CCFluids.squidInk, "Squid Ink", "Keep it out of your eyes!");
        this.addFluid(CCFluids.commonInk, "Common Ink", "Weakens the target's magic");
        this.addFluid(CCFluids.uncommonInk, "Uncommon Ink", "Weakens the target's magic");
        this.addFluid(CCFluids.rareInk, "Rare Ink", "Weakens the target's magic");
        this.addFluid(CCFluids.epicInk, "Epic Ink", "Weakens the target's magic");
        this.addFluid(CCFluids.legendaryInk, "Legendary Ink", "Weakens the target's magic");
        this.addItem((Supplier)CCItems.potatoStewBowl, "Potato Stew");
        this.addItem((Supplier)CCItems.poisonousPotatoStewBowl, "Poisonous Potato Stew");
        this.addItem((Supplier)CCItems.exiliteIngot, "Exilite Ingot");
        this.addItem((Supplier)CCItems.exiliteNugget, "Exilite Nugget");
        this.addItem((Supplier)CCItems.exiliteReinforcement, "Exilite Reinforcement");
        this.addItem((Supplier)CCItems.travellersSpellbook, "Traveller's Spellbook");
        this.addItem((Supplier)CCItems.platedSpellbook, "Plated Spellbook");
        this.add("item.constructs_casting.plated_spellbook.description", "A heavily fortified spellbook geared towards defense rather than spell power.");
        this.addItem((Supplier)CCItems.slimySpellbook, "Slimy Spellbook");
        this.addItem((Supplier)CCItems.eldritchStaff, "Sculk Staff");
        this.addItem((Supplier)CCItems.wand, "Wand");
        this.add("item.constructs_casting.wand.description", "The wand is a simple casting implement. It buffs spell casting, and allows you to cast spells on right click.");
        this.addItem((Supplier)CCItems.battlestaff, "Battlestaff");
        this.add("item.constructs_casting.battlestaff.description", "The Battlestaff is a hybrid melee/magic weapon. Both melee and magic attacks will hit hard with one of these.");
        this.addItem((Supplier)CCItems.spellbookPlating, "Spellbook Plating");
        this.add(CCItems.spellbookPlatingCast.getSand().m_5524_(), "Spellbook Plating Sand Cast");
        this.add(((Item)CCItems.spellbookPlatingCast.get()).m_5524_(), "Spellbook Plating Gold Cast");
        this.add(CCItems.spellbookPlatingCast.getRedSand().m_5524_(), "Spellbook Plating Red Sand Cast");
        this.addItem((Supplier)CCItems.spellbookCover, "Spellbook Cover");
        this.addItem((Supplier)CCItems.pages, "Pages");
        this.addItem((Supplier)CCItems.facetedGem, "Faceted Gem");
        this.addItem((Supplier)CCItems.wandRod, "Wand Rod");
        this.add(((Item)CCItems.facetedGemCast.get()).m_5524_(), "Faceted Gem Gold Cast");
        this.add(CCItems.facetedGemCast.getSand().m_5524_(), "Faceted Gem Sand Cast");
        this.add(CCItems.facetedGemCast.getRedSand().m_5524_(), "Faceted Gem Red Sand Cast");
        this.add("gui.constructs_casting.fluid.bottle", "%s Bottles");
        this.add("ui.constructs_casting.spellbook_has_slots", "Cannot modify, remove spells from spellbook first");
        this.addItem((Supplier)CCItems.wizardslimeBall, "Wizardslime Ball");
        this.add("school.constructs_casting.slime", "Slime");
        this.addSpell((Supplier<AbstractSpell>)CCSpells.FREEZE_SPELL, "Freeze", "Rapidly cools down the targeted Casting Table or Basin, instantly finishing the casting process. Only works on molten metals.");
        this.add("spell.constructs_casting.freeze.invalid_target", "Invalid target!");
        this.add("ui.constructs_casting.slimeball.max_bounces", "%s Bounces");
        this.add("ui.constructs_casting.enderference_anti_teleport", "Your current affliction prevents you from teleporting...");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.inkyImpairment, "Inky Impairment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.magicEmpowerment, "Magic Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.magicVulnerability, "Magic Vulnerability");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.bloodEmpowerment, "Blood Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.enderEmpowerment, "Ender Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.evocationEmpowerment, "Evocation Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.fireEmpowerment, "Fire Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.holyEmpowerment, "Holy Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.iceEmpowerment, "Ice Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.lightningEmpowerment, "Lightning Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.natureEmpowerment, "Nature Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.recoveryEmpowerment, "Recovery Empowerment");
        this.add("fluid_effect.constructs_casting.add_mana", "Adds 50 mana to the target");
        this.add("fluid_effect.constructs_casting.subtract", "Subtracts 50 mana from the target");
        this.addFluid(CCFluids.moltenCrystallizedCoral, "Molten Crystallized Coral", "");
        this.addFluid(CCFluids.gasifiedRedstone, "Redstone", "");
        this.addFluid(CCFluids.moltenPearl, "Molten Pearl", "");
        this.addFluid(CCFluids.abyssalEssence, "Abyssal Essence", "");
        this.addFluid(CCFluids.technomancyEssence, "Technomancy Essence", "");
        this.addFluid(CCFluids.aquaEssence, "Aqua Essence", "");
        this.add("item.tconstruct.creative_slot.affinity", "Creative Affinity Slot");
        this.add("stat.tconstruct.slot.prefix.affinity", "Affinity Slots: ");
        this.add("stat.tconstruct.slot.display.affinity", "affinity");
        this.add("modifier.tconstruct.rebalanced.affinity", "Affinity");
        this.addModifier(CCModifiers.IMPROVEABLE, "Improvable", "Upgrades are good. But they can be better.", "Adds two bonus Affinity slots to the tool.");
        this.addModifier(CCModifiers.REGROWTH, "Regrowth", "The best brown thing!", "Increases Mana Regeneration by 10%.");
        this.addModifier(CCModifiers.CONSERVING.getId(), "Conserving", "Great deals all day!", "Reduces the mana cost of casting spells by 10.");
        this.addModifier(CCModifiers.EXPEDIENT, "Expedient", "In a big-time rush?", "Reduces spell cast time by 10%.");
        this.addModifier(CCModifiers.SOLAR_CHARGED.getId(), "Solar Charged", "The best green thing!", "Empowers Mana Regeneration while under sunlight.");
        this.add("modifier.constructs_casting.solar_charged.boost", "Solar Charged Mana Regen");
        this.addModifier(CCModifiers.THICK_SKINNED, "Thick-Skinned", "You monster", "Increases spell power and cooldowns in hot biomes, reduces spell power and cooldowns in cold biomes.");
        this.add("modifier.constructs_casting.thick_skinned.spell_power", "Thick-Skinned Spell Power");
        this.add("modifier.constructs_casting.thick_skinned.cooldown_reduction", "Thick-Skinned Cooldown Reduction");
        this.addModifier(CCModifiers.ICHORSPELLS, "Ichorspells", "You are filled with ichor... and determination I guess", "Increases Spell Power by 15% in exchange for -30% mana regeneration");
        this.addModifier(CCModifiers.DRAGONSPELLS.getId(), "Dragonspells", "In their tongue he is Dovahtiinker, dragonsmith", "Increases Spell Power by 10% while mid-air.");
        this.addModifier(CCModifiers.GASHING.getId(), "Gashing", "You haemophile", "Dealing damage with spells has a 50% chance to apply the Bleeding effect");
        this.addModifier(CCModifiers.PUNCTURING.getId(), "Puncturing", "Why is magic blocked by armor anyways?", "Spell damage cancels out some of the target's armor!");
        this.addModifier(CCModifiers.ENDERBENDER.getId(), "Enderbender", "Hey, I've seen this one before!", "Teleporting via spell grants the Evasion effect");
        this.addModifier(CCModifiers.APOPTOTIC.getId(), "Apoptotic", "This may be overpowered but who knows", "Dealing spell damage over a certain threshold heals you");
        this.addModifier(CCModifiers.CALORIFIC.getId(), "Calorific", "Hot ones, and by ones I mean spells", "Spells deal multiplied damage when you are on fire");
        this.add("modifier.constructs_casting.calorific.boost", "On-Fire Boost Max");
        this.addModifier(CCModifiers.RINGBEARER, "Ringbearer", "Does it give you two more fingers?", "Allows you to wear two more rings");
        this.addModifier(CCModifiers.SLOT_IMPROVEMENT, "Slot Improvement", "65%% more spell per spell!", "Grants +1 Spell Slot. (Cannot exceed 15 total Spell Slots)");
    }

    public void addMaterial(MaterialId material, String name, String flavour, String desc) {
        String id = material.m_135815_();
        this.add("material.constructs_casting." + id, name);
        if (!flavour.isEmpty()) {
            this.add("material.constructs_casting." + id + ".flavor", flavour);
        }
        if (!desc.isEmpty()) {
            this.add("material.constructs_casting." + id + ".encyclopedia", desc);
        }
    }

    public void addModifier(ModifierId modifier, String name, String flavour, String desc) {
        String id = modifier.m_135815_();
        this.add("modifier.constructs_casting." + id, name);
        this.add("modifier.constructs_casting." + id + ".flavor", flavour);
        this.add("modifier.constructs_casting." + id + ".description", desc);
    }

    public void addFluid(FluidObject<?> fluid, String name, String effect) {
        this.add("fluid.constructs_casting." + fluid.getId().m_135815_(), name);
        this.add("fluid.constructs_casting." + fluid.getId().m_135815_() + ".fluid_effect", effect);
        this.add("fluid_type.constructs_casting." + fluid.getId().m_135815_(), name);
        this.add("item.constructs_casting." + fluid.getId().m_135815_() + "_bucket", name + " Bucket");
    }

    public void addSpell(Supplier<AbstractSpell> spell, String name, String desc) {
        this.add("spell.constructs_casting." + spell.get().getSpellName(), name);
        this.add("spell.constructs_casting." + spell.get().getSpellName() + ".guide", desc);
    }
}

