/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.fluids;

import com.snackpirate.constructscasting.fluids.CCFluids;
import com.snackpirate.constructscasting.items.CCItems;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.network.ClientboundSyncMana;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.setup.Messages;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.data.tinkering.AbstractFluidEffectProvider;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidMobEffect;
import slimeknights.tconstruct.library.modifiers.fluid.TimeAction;
import slimeknights.tconstruct.library.modifiers.fluid.entity.RestoreHungerFluidEffect;

public class CCFluidEffects
extends AbstractFluidEffectProvider {
    public static FluidEffect<FluidEffectContext.Entity> DEPLETE_MANA = FluidEffect.simple((fluid, level, context, action) -> {
        if (action.execute()) {
            LivingEntity living = context.getLivingTarget();
            MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)living);
            playerMagicData.addMana(-50.0f * level.value());
            if (living instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)living;
                Messages.sendToPlayer((Object)new ClientboundSyncMana(playerMagicData), (ServerPlayer)serverPlayer);
            }
        }
        return level.value();
    });
    public static FluidEffect<FluidEffectContext.Entity> ADD_MANA = FluidEffect.simple((fluid, level, context, action) -> {
        if (action.execute()) {
            LivingEntity living = context.getLivingTarget();
            MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)living);
            playerMagicData.addMana(10.0f * level.value());
            if (living instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)living;
                Messages.sendToPlayer((Object)new ClientboundSyncMana(playerMagicData), (ServerPlayer)serverPlayer);
            }
        }
        return level.value();
    });

    public CCFluidEffects(PackOutput packOutput, String modId) {
        super(packOutput, modId);
    }

    protected void addFluids() {
        this.addFluid(CCFluids.Tags.essenceOf("arcane"), 50).addEntityEffect(ADD_MANA);
        this.addFluid(CCFluids.Tags.essenceOf("cinder"), 50).addEntityEffect(DEPLETE_MANA);
        this.addFluid(CCFluids.Tags.MOLTEN_ARCANIUM, 10).fireDamage(2.0f).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.magicEmpowerment.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.MOLTEN_EXILITE, 10).fireDamage(2.0f).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.magicVulnerability.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.essenceOf("blood"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.bloodEmpowerment.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.essenceOf("ender"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.enderEmpowerment.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.essenceOf("evocation"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.evocationEmpowerment.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.essenceOf("fire"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.fireEmpowerment.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.essenceOf("holy"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.holyEmpowerment.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.essenceOf("ice"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.iceEmpowerment.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.essenceOf("lightning"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.lightningEmpowerment.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.essenceOf("nature"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.natureEmpowerment.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.MOLTEN_ARCANE_SALVAGE, 10).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.recoveryEmpowerment.get(), 100, 2), TimeAction.SET);
        this.addFluid((FluidObject)CCFluids.potatoStew, 50).addEntityEffect((FluidEffect)new RestoreHungerFluidEffect(2, 0.48f, false, ItemOutput.fromItem((ItemLike)CCItems.potatoStewBowl.get())));
        this.addFluid((FluidObject)CCFluids.poisonousPotatoStew, 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffectRegistry.BLIGHT.get(), 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.squidInk, 50).addEffect(FluidMobEffect.builder().effect(net.minecraft.world.effect.MobEffects.f_19610_, 100, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.ink("common"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.inkyImpairment.get(), 160, 1), TimeAction.SET);
        this.addFluid(CCFluids.Tags.ink("uncommon"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.inkyImpairment.get(), 170, 2), TimeAction.SET);
        this.addFluid(CCFluids.Tags.ink("rare"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.inkyImpairment.get(), 180, 3), TimeAction.SET);
        this.addFluid(CCFluids.Tags.ink("epic"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.inkyImpairment.get(), 190, 4), TimeAction.SET);
        this.addFluid(CCFluids.Tags.ink("legendary"), 50).addEffect(FluidMobEffect.builder().effect((MobEffect)MobEffects.inkyImpairment.get(), 200, 5), TimeAction.SET);
    }

    public String m_6055_() {
        return "Construct's Casting Fluid Effect Provider";
    }

    public static class MobEffects {
        public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((ResourceKey)Registries.f_256929_, (String)"constructs_casting");
        public static RegistryObject<MobEffect> magicEmpowerment = EFFECTS.register("magic_empowerment", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 12968447, true).addAttributeModifier((Attribute)AttributeRegistry.SPELL_POWER.get(), "e39931d9-140b-493d-8c4d-2a1e89393024", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> magicVulnerability = EFFECTS.register("magic_vulnerability", () -> new TinkerEffect(MobEffectCategory.HARMFUL, 5595519, true).addAttributeModifier((Attribute)AttributeRegistry.SPELL_RESIST.get(), "dfccaea6-24db-4bc6-ac68-2f54d1c00232", -0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> inkyImpairment = EFFECTS.register("inky_impairment", () -> new TinkerEffect(MobEffectCategory.HARMFUL, 0x15111F, true).addAttributeModifier((Attribute)AttributeRegistry.SPELL_POWER.get(), "bfccaea6-24db-4bc6-ac68-2f54d1c00232", -0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> fireEmpowerment = EFFECTS.register("fire_empowerment", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 16754533, true).addAttributeModifier((Attribute)AttributeRegistry.FIRE_SPELL_POWER.get(), "713959a9-bed7-427d-975f-809ed994cd17", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> iceEmpowerment = EFFECTS.register("ice_empowerment", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 7208949, true).addAttributeModifier((Attribute)AttributeRegistry.ICE_SPELL_POWER.get(), "32cae3f7-78fd-4ea4-b263-0884524384ae", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> lightningEmpowerment = EFFECTS.register("lightning_empowerment", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 14737148, true).addAttributeModifier((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get(), "2b98d41e-509a-4313-a7ab-a9f2131f5149", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> holyEmpowerment = EFFECTS.register("holy_empowerment", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 16775863, true).addAttributeModifier((Attribute)AttributeRegistry.HOLY_SPELL_POWER.get(), "db523eaa-ccbe-4a9e-8ecc-a4e22dc53a95", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> enderEmpowerment = EFFECTS.register("ender_empowerment", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 14382335, true).addAttributeModifier((Attribute)AttributeRegistry.ENDER_SPELL_POWER.get(), "db64740a-572f-4a52-92ba-1c32b9bdc7a5", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> bloodEmpowerment = EFFECTS.register("blood_empowerment", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 0xFF7070, true).addAttributeModifier((Attribute)AttributeRegistry.BLOOD_SPELL_POWER.get(), "6a0239c2-c775-4214-8b52-31ea7bd5fbfa", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> evocationEmpowerment = EFFECTS.register("evocation_empowerment", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 0x99FF9C, true).addAttributeModifier((Attribute)AttributeRegistry.EVOCATION_SPELL_POWER.get(), "ecd54855-033c-4309-8866-3d567d6e15f0", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> natureEmpowerment = EFFECTS.register("nature_empowerment", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 11597929, true).addAttributeModifier((Attribute)AttributeRegistry.NATURE_SPELL_POWER.get(), "6fdc0348-9e68-4165-9d93-43dc2fdf796e", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
        public static RegistryObject<MobEffect> recoveryEmpowerment = EFFECTS.register("recovery_empowerment", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 15590630, true).addAttributeModifier((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get(), "6fdc0fff-9e68-4165-9d93-43dc2fdf796e", 0.15, AttributeModifier.Operation.MULTIPLY_TOTAL));

        public static void register(IEventBus eventBus) {
            EFFECTS.register(eventBus);
        }
    }
}

