/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.snackpirate.constructscasting.items.CCItems;
import com.snackpirate.constructscasting.materials.CCToolStats;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.ITinkerStationDisplay;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifiableMagicStaff
extends ModifiableItem {
    public ModifiableMagicStaff(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(IToolStackView tool, EquipmentSlot slot) {
        ImmutableMultimap.Builder attributeBuilder = new ImmutableMultimap.Builder();
        attributeBuilder.putAll(super.getAttributeModifiers(tool, slot));
        UUID uuid = AttributesModifierHook.HELD_ARMOR_UUID[slot.m_20749_()];
        float spBonus = ((Float)tool.getStats().get((IToolStat)CCToolStats.SPELL_POWER)).floatValue();
        attributeBuilder.put((Object)((Attribute)AttributeRegistry.SPELL_POWER.get()), (Object)new AttributeModifier(uuid, "tool.constructs_casting.spell_power_bonus", (double)spBonus, AttributeModifier.Operation.MULTIPLY_BASE));
        float cdBonus = ((Float)tool.getStats().get((IToolStat)CCToolStats.COOLDOWN_REDUCTION)).floatValue();
        attributeBuilder.put((Object)((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get()), (Object)new AttributeModifier(uuid, "tool.constructs_casting.cd_reduction", (double)cdBonus, AttributeModifier.Operation.MULTIPLY_BASE));
        return attributeBuilder.build();
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_() || !this.m_204114_().m_203656_(TinkerTags.Items.MELEE);
    }

    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltip);
        if (tool.hasTag(TinkerTags.Items.DURABILITY)) {
            builder.addDurability();
        }
        if (tool.hasTag(TinkerTags.Items.RANGED)) {
            builder.add((IToolStat)ToolStats.DRAW_SPEED);
            builder.add((IToolStat)ToolStats.VELOCITY);
            builder.add((IToolStat)ToolStats.PROJECTILE_DAMAGE);
            builder.add((IToolStat)ToolStats.ACCURACY);
        }
        if (tool.hasTag(TinkerTags.Items.MELEE_WEAPON)) {
            builder.addWithAttribute((INumericToolStat)ToolStats.ATTACK_DAMAGE, Attributes.f_22281_);
            builder.add((IToolStat)ToolStats.ATTACK_SPEED);
        }
        if (tool.hasTag(CCItems.Tags.MOD_STAFFS)) {
            builder.add((IToolStat)CCToolStats.SPELL_POWER);
            builder.add((IToolStat)CCToolStats.COOLDOWN_REDUCTION);
        }
        if (tool.hasTag(TinkerTags.Items.HARVEST)) {
            if (tool.hasTag(TinkerTags.Items.HARVEST_PRIMARY)) {
                builder.addTier();
            }
            builder.add((IToolStat)ToolStats.MINING_SPEED);
        }
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            builder.addOptional((INumericToolStat)ToolStats.ARMOR);
            builder.addOptional((INumericToolStat)ToolStats.ARMOR_TOUGHNESS);
            builder.addOptional((INumericToolStat)ToolStats.KNOCKBACK_RESISTANCE, 10.0f);
        }
        if (tool.getModifierLevel(TinkerModifiers.blocking.getId()) > 0 || tool.getModifierLevel(TinkerModifiers.parrying.getId()) > 0) {
            builder.add((IToolStat)ToolStats.BLOCK_AMOUNT);
            builder.add((IToolStat)ToolStats.BLOCK_ANGLE);
        }
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            ((TooltipModifierHook)entry.getHook(ModifierHooks.TOOLTIP)).addTooltip(tool, entry, player, tooltip, key, flag);
        }
        TooltipUtil.addAttributes((ITinkerStationDisplay)this, (IToolStackView)tool, (Player)player, tooltip, (BiPredicate)TooltipUtil.SHOW_MELEE_ATTRIBUTES, (EquipmentSlot[])new EquipmentSlot[]{EquipmentSlot.MAINHAND});
        return builder.getTooltips();
    }
}

