/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.snackpirate.constructscasting.items.CCItems;
import com.snackpirate.constructscasting.materials.CCMaterials;
import com.snackpirate.constructscasting.materials.CCToolStats;
import com.snackpirate.constructscasting.modifiers.CCModifiers;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.compat.Curios;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import top.theillusivec4.curios.api.SlotContext;

public class ModifiableSpellbookItem
extends SpellBook
implements IModifiableDisplay {
    private final ToolDefinition definition;
    private ItemStack toolForRendering;

    public ModifiableSpellbookItem(Item.Properties prop, int slots, ToolDefinition definition) {
        super(slots, SpellRarity.EPIC, prop);
        this.definition = definition;
    }

    public Component m_7626_(ItemStack stack) {
        return TooltipUtil.getDisplayName((ItemStack)stack, (ToolDefinition)this.getToolDefinition());
    }

    public ToolDefinition getToolDefinition() {
        return this.definition;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        this.spellbookLines(itemStack, level, lines, flag, SafeClientAccess.getTooltipKey());
        TooltipUtil.addInformation((IModifiableDisplay)this, (ItemStack)itemStack, (Level)level, lines, (TooltipKey)SafeClientAccess.getTooltipKey(), (TooltipFlag)flag);
    }

    public void spellbookLines(ItemStack itemStack, Level level, List<Component> lines, TooltipFlag flag, TooltipKey key) {
        ISpellContainer spellList;
        List activeSpellSlots;
        Player player;
        if (key == TooltipKey.CONTROL || key == TooltipKey.SHIFT) {
            return;
        }
        if (this.isUnique()) {
            lines.add((Component)Component.m_237110_((String)"tooltip.irons_spellbooks.spellbook_rarity", (Object[])new Object[]{Component.m_237115_((String)"tooltip.irons_spellbooks.spellbook_unique").m_130948_(TooltipsUtils.UNIQUE_STYLE)}).m_130940_(ChatFormatting.GRAY));
        }
        if ((player = MinecraftInstanceHelper.getPlayer()) != null && ISpellContainer.isSpellContainer((ItemStack)itemStack) && !(activeSpellSlots = (spellList = ISpellContainer.get((ItemStack)itemStack)).getActiveSpells()).isEmpty()) {
            lines.add((Component)Component.m_237115_((String)"tooltip.irons_spellbooks.spellbook_tooltip").m_130940_(ChatFormatting.GRAY));
            SpellSelectionManager spellSelectionManager = ClientMagicData.getSpellSelectionManager();
            for (int i = 0; i < activeSpellSlots.size(); ++i) {
                MutableComponent spellText = TooltipsUtils.getTitleComponent((SpellData)((SpellData)activeSpellSlots.get(i)), (LocalPlayer)((LocalPlayer)player)).m_6270_(Style.f_131099_);
                if (MinecraftInstanceHelper.getPlayer() != null && Utils.getPlayerSpellbookStack((Player)MinecraftInstanceHelper.getPlayer()) == itemStack && spellSelectionManager.getCurrentSelection().equipmentSlot.equals(Curios.SPELLBOOK_SLOT) && i == spellSelectionManager.getSelectionIndex()) {
                    List shiftMessage = TooltipsUtils.formatActiveSpellTooltip((ItemStack)itemStack, (SpellData)spellSelectionManager.getSelectedSpellData(), (CastSource)CastSource.SPELLBOOK, (LocalPlayer)((LocalPlayer)player));
                    shiftMessage.remove(0);
                    TooltipsUtils.addShiftTooltip(lines, (Component)Component.m_237113_((String)"> ").m_7220_((Component)spellText).m_130940_(ChatFormatting.YELLOW), shiftMessage.stream().map(component -> Component.m_237113_((String)" ").m_7220_((Component)component)).collect(Collectors.toList()));
                    continue;
                }
                lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)spellText.m_130948_(Style.f_131099_.m_178520_(0x8888FE))));
            }
        }
    }

    public ItemStack getRenderTool() {
        if (this.toolForRendering == null) {
            ItemStack stack = new ItemStack((ItemLike)this);
            if (!this.definition.isDataLoaded() || this.definition.hasMaterials()) {
                stack = new MaterialIdNBT(Arrays.asList(MaterialIds.cobalt, MaterialIds.wood, CCMaterials.paper)).updateStack(stack);
            }
            stack.m_41784_().m_128379_("tic_display", true);
            this.toolForRendering = stack;
        }
        return this.toolForRendering;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public void m_142312_(CompoundTag pCompoundTag) {
        ToolStack.verifyTag((Item)this, (CompoundTag)pCompoundTag, (ToolDefinition)this.getToolDefinition());
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        ToolStack.ensureInitialized((ItemStack)pStack, (ToolDefinition)this.getToolDefinition());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        ImmutableMultimap.Builder attributeBuilder = new ImmutableMultimap.Builder();
        ToolStack tool = ToolStack.from((ItemStack)stack);
        int manaBonus = tool.getStats().getInt((IToolStat)CCToolStats.MAX_MANA);
        attributeBuilder.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier("tool.constructs_casting.mana_bonus", (double)manaBonus, AttributeModifier.Operation.ADDITION));
        float spBonus = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)slotContext.entity(), (FloatToolStat)CCToolStats.SPELL_POWER);
        attributeBuilder.put((Object)((Attribute)AttributeRegistry.SPELL_POWER.get()), (Object)new AttributeModifier("tool.constructs_casting.spell_power_bonus", (double)spBonus, AttributeModifier.Operation.MULTIPLY_BASE));
        float cdBonus = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)slotContext.entity(), (FloatToolStat)CCToolStats.COOLDOWN_REDUCTION);
        attributeBuilder.put((Object)((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get()), (Object)new AttributeModifier("tool.constructs_casting.cd_reduction", (double)cdBonus, AttributeModifier.Operation.MULTIPLY_BASE));
        for (ModifierEntry entry : tool.getModifierList()) {
            ((AttributesModifierHook)entry.getHook(ModifierHooks.ATTRIBUTES)).addAttributes((IToolStackView)tool, entry, EquipmentSlot.LEGS, (attr, mod) -> {
                AttributeModifier newMod = new AttributeModifier(mod.m_22209_(), mod.m_22214_() + ".spellbook", mod.m_22218_(), mod.m_22217_());
                attributeBuilder.put(attr, (Object)newMod);
            });
        }
        return attributeBuilder.build();
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        AttributeInstance maxMana = slotContext.entity().m_21051_((Attribute)AttributeRegistry.MAX_MANA.get());
        maxMana.m_22122_().stream().filter(modifier -> modifier.m_22214_().equals("tool.constructs_casting.mana_bonus")).forEach(arg_0 -> ((AttributeInstance)maxMana).m_22130_(arg_0));
        AttributeInstance sp = slotContext.entity().m_21051_((Attribute)AttributeRegistry.SPELL_POWER.get());
        sp.m_22122_().stream().filter(modifier -> modifier.m_22214_().equals("tool.constructs_casting.spell_power_bonus")).forEach(arg_0 -> ((AttributeInstance)sp).m_22130_(arg_0));
        AttributeInstance cd = slotContext.entity().m_21051_((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get());
        cd.m_22122_().stream().filter(modifier -> modifier.m_22214_().equals("tool.constructs_casting.cd_reduction")).forEach(arg_0 -> ((AttributeInstance)cd).m_22130_(arg_0));
        EquipmentChangeContext context = new EquipmentChangeContext(slotContext.entity(), EquipmentSlot.LEGS, stack, newStack);
        for (ModifierEntry entry : tool.getModifierList()) {
            ((EquipmentChangeModifierHook)entry.getHook(ModifierHooks.EQUIPMENT_CHANGE)).onUnequip((IToolStackView)tool, entry, context);
            ((AttributesModifierHook)entry.getHook(ModifierHooks.ATTRIBUTES)).addAttributes((IToolStackView)tool, entry, EquipmentSlot.LEGS, (attr, mod) -> {
                AttributeModifier newMod = new AttributeModifier(mod.m_22209_(), mod.m_22214_() + ".spellbook", mod.m_22218_(), mod.m_22217_());
                slotContext.entity().m_21051_(attr).m_22130_(newMod);
            });
        }
        super.onUnequip(slotContext, newStack, stack);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return ToolStack.from((ItemStack)stack).getModifierLevel(CCModifiers.ENCYCLOPEDIC.getId()) < 1;
    }

    protected static boolean shouldInteract(@Nullable LivingEntity player, ToolStack toolStack, InteractionHand hand) {
        IModDataView volatileData = toolStack.getVolatileData();
        if (volatileData.getBoolean(NO_INTERACTION)) {
            return false;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return true;
        }
        return player == null || !volatileData.getBoolean(DEFER_OFFHAND) || player.m_21206_().m_41619_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41613_() > 1) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (ModifiableSpellbookItem.shouldInteract((LivingEntity)playerIn, tool, hand)) {
            for (ModifierEntry entry : tool.getModifierList()) {
                InteractionResult result = ((GeneralInteractionModifierHook)entry.getHook(ModifierHooks.GENERAL_INTERACT)).onToolUse((IToolStackView)tool, entry, playerIn, hand, InteractionSource.RIGHT_CLICK);
                if (!result.m_19077_()) continue;
                return new InteractionResultHolder(result, (Object)stack);
            }
        }
        return new InteractionResultHolder(ToolInventoryCapability.tryOpenContainer((ItemStack)stack, (IToolStackView)tool, (Player)playerIn, (EquipmentSlot)Util.getSlotType((InteractionHand)hand)), (Object)stack);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        ToolStack.ensureInitialized((ItemStack)stack, (ToolDefinition)this.getToolDefinition());
        ToolStack tool = ToolStack.from((ItemStack)stack);
        EquipmentChangeContext context = new EquipmentChangeContext(slotContext.entity(), EquipmentSlot.LEGS, prevStack, stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            ((EquipmentChangeModifierHook)entry.getHook(ModifierHooks.EQUIPMENT_CHANGE)).onEquip((IToolStackView)tool, entry, context);
        }
        this.initializeSpellContainer(stack);
    }

    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltips);
        if (tool.hasTag(CCItems.Tags.MOD_SPELLBOOKS)) {
            builder.add((IToolStat)CCToolStats.MAX_MANA);
            builder.add((IToolStat)CCToolStats.SPELL_POWER);
            builder.add((IToolStat)CCToolStats.SPELL_SLOTS);
            builder.add((IToolStat)CCToolStats.COOLDOWN_REDUCTION);
        }
        super.getStatInformation(tool, player, tooltips, key, tooltipFlag);
        return tooltips;
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        ToolStack tool = ToolStack.from((ItemStack)itemStack);
        tool.ensureHasData();
        int spells = tool.getStats().getInt((IToolStat)CCToolStats.SPELL_SLOTS);
        if (spells == 0) {
            return;
        }
        if (!ISpellContainer.isSpellContainer((ItemStack)itemStack)) {
            ISpellContainer spellContainer = ISpellContainer.create((int)spells, (boolean)true, (boolean)true);
            spellContainer.save(itemStack);
        } else if (ISpellContainer.get((ItemStack)itemStack).getMaxSpellCount() != spells) {
            ISpellContainer spellContainer = ISpellContainer.get((ItemStack)itemStack);
            spellContainer.setMaxSpellCount(spells);
            spellContainer.save(itemStack);
        }
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            ((InventoryTickModifierHook)entry.getHook(ModifierHooks.INVENTORY_TICK)).onInventoryTick((IToolStackView)tool, entry, level, (LivingEntity)player, EquipmentSlot.LEGS.m_20749_(), false, true, stack);
        }
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
    }

    public boolean canSync(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            ((InventoryTickModifierHook)entry.getHook(ModifierHooks.INVENTORY_TICK)).onInventoryTick((IToolStackView)tool, entry, slotContext.entity().m_9236_(), slotContext.entity(), EquipmentSlot.LEGS.m_20749_(), false, true, stack);
        }
        super.curioTick(slotContext, stack);
    }
}

