/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.materials;

import com.snackpirate.constructscasting.ConstructsCasting;
import com.snackpirate.constructscasting.materials.CCMaterialStats;
import com.snackpirate.constructscasting.materials.MagicBaseMaterialStats;
import com.snackpirate.constructscasting.materials.MagicClothMaterialStats;
import com.snackpirate.constructscasting.modifiers.CCModifiers;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialRenderInfoProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialStatsDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialTraitDataProvider;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class CCMaterials
extends AbstractMaterialDataProvider {
    public static final List<MaterialVariantId> tinkerClothMaterials = List.of(MaterialIds.leather, MaterialIds.slimeskin, MaterialIds.ichorskin, MaterialIds.skySlimeskin, MaterialIds.enderSlimeskin, MaterialIds.roseGold);
    public static final List<MaterialVariantId> tinkerMagicMaterials = List.of(MaterialIds.wood, MaterialIds.nahuatl, MaterialIds.bone, MaterialIds.blazewood, MaterialIds.bamboo, MaterialIds.bone, MaterialIds.blazingBone, MaterialIds.necroticBone);
    public static final MaterialId arcanium = CCMaterials.createMaterial("arcanium");
    public static final MaterialId exilite = CCMaterials.createMaterial("exilite");
    public static final MaterialId arcaneCloth = CCMaterials.createMaterial("arcane_cloth");
    public static final MaterialId frozenBone = CCMaterials.createMaterial("frozen_bone");
    public static final MaterialId frostRod = CCMaterials.createMaterial("frosted_rod");
    public static final MaterialId hogskin = CCMaterials.createMaterial("hogskin");
    public static final MaterialId dragonskin = CCMaterials.createMaterial("dragonskin");
    public static final MaterialId rainbowSlime = CCMaterials.createMaterial("rainbowslime");
    public static final MaterialId cosmichalcum = CCMaterials.createMaterial("cosmichalcum");
    public static final MaterialId paper = CCMaterials.createMaterial("paper");
    public static final MaterialId leaf = CCMaterials.createMaterial("leaf");
    public static final MaterialId amethyst = CCMaterials.createMaterial("amethyst");
    public static final MaterialId quartz = CCMaterials.createMaterial("quartz");
    public static final MaterialId emerald = CCMaterials.createMaterial("emerald");
    public static final MaterialId earthslimeCrystal = CCMaterials.createMaterial("earthslime_crystal");
    public static final MaterialId skyslimeCrystal = CCMaterials.createMaterial("skyslime_crystal");
    public static final MaterialId enderslimeCrystal = CCMaterials.createMaterial("enderslime_crystal");
    public static final MaterialId ichorCrystal = CCMaterials.createMaterial("ichor_crystal");
    public static final MaterialId permafrost = CCMaterials.createMaterial("permafrost");
    public static final MaterialId glowstone = CCMaterials.createMaterial("glowstone");
    public static final MaterialId echoShard = CCMaterials.createMaterial("echo_shard");
    public static final List<MaterialId> crystalMaterials = List.of(amethyst, quartz, emerald, earthslimeCrystal, skyslimeCrystal, enderslimeCrystal, ichorCrystal, permafrost, glowstone, echoShard);

    public CCMaterials(PackOutput gen) {
        super(gen);
    }

    private static MaterialId createMaterial(String name) {
        return new MaterialId(ConstructsCasting.id(name));
    }

    protected void addMaterials() {
        this.addMaterial(paper, 1, 0, true);
        this.addMaterial(frozenBone, 2, 12, true);
        this.addMaterial(hogskin, 2, 0, true);
        this.addMaterial(arcaneCloth, 2, 13, true);
        this.addMaterial(leaf, 2, 0, true);
        this.addMaterial(arcanium, 3, 15, false);
        this.addMaterial(exilite, 3, 16, false);
        this.addMaterial(frostRod, 3, 14, true);
        this.addMaterial(rainbowSlime, 3, 0, false);
        this.addMaterial(dragonskin, 4, 0, true);
        this.addMaterial(amethyst, 1, 0, true);
        this.addMaterial(permafrost, 1, 0, true);
        this.addMaterial(quartz, 2, 0, false);
        this.addMaterial(glowstone, 2, 0, true);
        this.addMaterial(earthslimeCrystal, 2, 0, true);
        this.addMaterial(skyslimeCrystal, 2, 0, true);
        this.addMaterial(emerald, 3, 0, false);
        this.addMaterial(enderslimeCrystal, 4, 0, true);
        this.addMaterial(ichorCrystal, 4, 0, true);
        this.addMaterial(echoShard, 4, 0, true);
    }

    public String m_6055_() {
        return "Construct's Casting Materials";
    }

    public static class CCMaterialRenderInfo
    extends AbstractMaterialRenderInfoProvider {
        public CCMaterialRenderInfo(PackOutput gen, @Nullable AbstractMaterialSpriteProvider materialSprites, ExistingFileHelper fileHelper) {
            super(gen, materialSprites, fileHelper);
        }

        protected void addMaterialRenderInfo() {
            this.buildRenderInfo((MaterialVariantId)arcanium).color(7580638);
            this.buildRenderInfo((MaterialVariantId)arcaneCloth).color(7580638).fallbacks(new String[]{"cloth"});
            this.buildRenderInfo((MaterialVariantId)hogskin).color(15245428).fallbacks(new String[]{"cloth", "primitive"});
            this.buildRenderInfo((MaterialVariantId)exilite).color(4671819);
            this.buildRenderInfo((MaterialVariantId)frozenBone).color(13690340).fallbacks(new String[]{"bone", "rock"});
            this.buildRenderInfo((MaterialVariantId)rainbowSlime).color(0xFFFF00);
            this.buildRenderInfo((MaterialVariantId)frostRod).color(0xC8ECEC).fallbacks(new String[]{"metal", "primitive"});
            this.buildRenderInfo((MaterialVariantId)leaf).color(4764952).fallbacks(new String[]{"vine"});
            this.buildRenderInfo((MaterialVariantId)dragonskin).color(4272712).fallbacks(new String[]{"rock", "primitive"});
            this.buildRenderInfo((MaterialVariantId)cosmichalcum).color(0x111081).fallbacks(new String[]{"metal"});
            this.buildRenderInfo((MaterialVariantId)paper).color(0xEEEEEE).fallbacks(new String[]{"cloth"});
            this.buildRenderInfo((MaterialVariantId)amethyst).color(0xEEEEEE).fallbacks(new String[]{"crystal"});
            this.buildRenderInfo((MaterialVariantId)permafrost).color(0xEEEEEE).fallbacks(new String[]{"crystal"});
            this.buildRenderInfo((MaterialVariantId)quartz).color(0xEEEEEE).fallbacks(new String[]{"crystal"});
            this.buildRenderInfo((MaterialVariantId)glowstone).color(0xEEEEEE).fallbacks(new String[]{"crystal"});
            this.buildRenderInfo((MaterialVariantId)earthslimeCrystal).color(0xEEEEEE).fallbacks(new String[]{"crystal"});
            this.buildRenderInfo((MaterialVariantId)skyslimeCrystal).color(0xEEEEEE).fallbacks(new String[]{"crystal"});
            this.buildRenderInfo((MaterialVariantId)emerald).color(0xEEEEEE).fallbacks(new String[]{"crystal"});
            this.buildRenderInfo((MaterialVariantId)enderslimeCrystal).color(0xEEEEEE).fallbacks(new String[]{"crystal"});
            this.buildRenderInfo((MaterialVariantId)ichorCrystal).color(0xEEEEEE).fallbacks(new String[]{"crystal"});
            this.buildRenderInfo((MaterialVariantId)echoShard).color(0xEEEEEE).fallbacks(new String[]{"crystal"});
        }

        public String m_6055_() {
            return "Construct's Casting Material Render Info";
        }
    }

    public static class CCMaterialTraits
    extends AbstractMaterialTraitDataProvider {
        public CCMaterialTraits(PackOutput gen, AbstractMaterialDataProvider materials) {
            super(gen, materials);
        }

        protected void addMaterialTraits() {
            this.addDefaultTraits(arcanium, new ModifierId[]{CCModifiers.ARCANE});
            this.addTraits(cosmichalcum, MaterialRegistry.MELEE_HARVEST, new ModifierId[]{CCModifiers.ENDER_UPGRADE});
            this.addTraits(cosmichalcum, MaterialRegistry.ARMOR, new ModifierId[]{CCModifiers.ENDER_UPGRADE});
            this.addDefaultTraits(arcaneCloth, new ModifierId[]{CCModifiers.SPELLBOUND});
            this.addDefaultTraits(hogskin, new ModifierId[]{CCModifiers.ARCANE});
            this.addDefaultTraits(frozenBone, new ModifierId[]{CCModifiers.ANTIFROST});
            this.addDefaultTraits(dragonskin, new LazyModifier[]{CCModifiers.DRAGONSPELLS});
            this.addTraits(frostRod, HandleMaterialStats.ID, new ModifierEntry[]{new ModifierEntry(CCModifiers.ICE_UPGRADE, 1)});
            this.addTraits(exilite, MaterialRegistry.MELEE_HARVEST, new LazyModifier[]{CCModifiers.ANTIMAGIC});
            this.addTraits(exilite, MaterialRegistry.ARMOR, new ModifierId[]{CCModifiers.SPELL_PROTECTION});
            this.addTraits(exilite, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.SPELL_DISPULSION});
            this.noTraits(rainbowSlime);
            this.addDefaultTraits(paper, new ModifierId[]{CCModifiers.IMPROVEABLE});
            this.addDefaultTraits(leaf, new LazyModifier[]{CCModifiers.SOLAR_CHARGED});
            this.addDefaultTraits(hogskin, new ModifierId[]{CCModifiers.THICK_SKINNED});
            this.addTraits(MaterialIds.leather, MagicClothMaterialStats.ID, new LazyModifier[]{CCModifiers.CONSERVING});
            this.addTraits(MaterialIds.ichorskin, MagicClothMaterialStats.ID, new ModifierId[]{CCModifiers.ICHORSPELLS});
            this.addTraits(MaterialIds.wood, MagicBaseMaterialStats.ID, new ModifierId[]{CCModifiers.REGROWTH});
            this.addTraits(MaterialIds.bamboo, MagicBaseMaterialStats.ID, new ModifierId[]{CCModifiers.EXPEDIENT});
            this.addTraits(MaterialIds.bone, MagicBaseMaterialStats.ID, new LazyModifier[]{CCModifiers.PUNCTURING});
            this.addTraits(MaterialIds.nahuatl, MagicBaseMaterialStats.ID, new LazyModifier[]{CCModifiers.GASHING});
            this.addTraits(MaterialIds.chorus, MagicBaseMaterialStats.ID, new LazyModifier[]{CCModifiers.ENDERBENDER});
            this.addTraits(MaterialIds.necroticBone, MagicBaseMaterialStats.ID, new LazyModifier[]{CCModifiers.APOPTOTIC});
            this.addTraits(MaterialIds.blazingBone, MagicBaseMaterialStats.ID, new LazyModifier[]{CCModifiers.CALORIFIC});
            this.addTraits(amethyst, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.COOLDOWN_UPGRADE});
            this.addTraits(quartz, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.FIRE_UPGRADE, CCModifiers.ICE_DISPULSION});
            this.addTraits(emerald, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.EVOCATION_UPGRADE, CCModifiers.NATURE_DISPULSION});
            this.addTraits(earthslimeCrystal, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.NATURE_UPGRADE, CCModifiers.EVOCATION_DISPULSION});
            this.addTraits(skyslimeCrystal, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.LIGHTNING_UPGRADE, CCModifiers.ENDER_DISPULSION});
            this.addTraits(enderslimeCrystal, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.ENDER_UPGRADE, CCModifiers.LIGHTNING_DISPULSION});
            this.addTraits(ichorCrystal, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.BLOOD_UPGRADE, CCModifiers.HOLY_DISPULSION});
            this.addTraits(permafrost, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.ICE_UPGRADE, CCModifiers.FIRE_DISPULSION});
            this.addTraits(glowstone, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.HOLY_UPGRADE, CCModifiers.BLOOD_DISPULSION});
            this.addTraits(echoShard, CCMaterialStats.Statless.ADORNMENT.getIdentifier(), new ModifierId[]{CCModifiers.ELDRITCH_UPGRADE, CCModifiers.ELDRITCH_DISPULSION});
        }

        public String m_6055_() {
            return "Construct's Casting Material Traits";
        }
    }

    public static class MaterialStats
    extends AbstractMaterialStatsDataProvider {
        public MaterialStats(PackOutput gen, AbstractMaterialDataProvider materials) {
            super(gen, materials);
        }

        protected void addMaterialStats() {
            this.addMaterialStats(arcanium, new IMaterialStats[]{new HeadMaterialStats(380, 7.0f, (Tier)Tiers.DIAMOND, 2.0f), new HandleMaterialStats(0.05f, 0.1f, -0.05f, -0.1f), StatlessMaterialStats.BINDING, new PlatingMaterialStats(PlatingMaterialStats.HELMET, 288, 2.0f, 2.0f, 0.1f), new PlatingMaterialStats(PlatingMaterialStats.CHESTPLATE, 428, 6.0f, 2.0f, 0.1f), new PlatingMaterialStats(PlatingMaterialStats.LEGGINGS, 400, 5.0f, 2.0f, 0.1f), new PlatingMaterialStats(PlatingMaterialStats.BOOTS, 344, 2.0f, 2.0f, 0.1f), new PlatingMaterialStats(PlatingMaterialStats.SHIELD, 484, 1.0f, 2.0f, 0.1f), StatlessMaterialStats.MAILLE, new LimbMaterialStats(380, 0.1f, -0.1f, 0.1f), new GripMaterialStats(0.05f, 0.1f, 2.0f), CCMaterialStats.Statless.ADORNMENT});
            this.addMaterialStats(exilite, new IMaterialStats[]{new HeadMaterialStats(480, 7.5f, (Tier)Tiers.DIAMOND, 2.5f), new HandleMaterialStats(-0.05f, -0.1f, 0.1f, 0.1f), StatlessMaterialStats.BINDING, new PlatingMaterialStats(PlatingMaterialStats.HELMET, 318, 2.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.CHESTPLATE, 458, 6.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.LEGGINGS, 430, 6.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.BOOTS, 374, 2.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.SHIELD, 514, 1.0f, 2.0f, 0.15f), StatlessMaterialStats.MAILLE, new LimbMaterialStats(480, -0.1f, 0.1f, -0.1f), new GripMaterialStats(-0.05f, -0.1f, 2.5f)});
            this.addMaterialStats(cosmichalcum, new IMaterialStats[]{new HeadMaterialStats(480, 7.5f, (Tier)Tiers.DIAMOND, 2.5f), new HandleMaterialStats(-0.05f, -0.15f, 0.15f, 0.1f), StatlessMaterialStats.BINDING, new PlatingMaterialStats(PlatingMaterialStats.HELMET, 318, 2.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.CHESTPLATE, 458, 6.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.LEGGINGS, 430, 6.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.BOOTS, 374, 2.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.SHIELD, 514, 1.0f, 2.0f, 0.15f), StatlessMaterialStats.MAILLE, CCMaterialStats.Statless.ADORNMENT});
            this.addMaterialStats(frozenBone, new IMaterialStats[]{new HeadMaterialStats(175, 4.0f, (Tier)Tiers.IRON, 2.5f), new HandleMaterialStats(0.1f, -0.05f, -0.1f, 0.1f), new MagicBaseMaterialStats(100.0f, 0.05f), StatlessMaterialStats.BINDING});
            this.addMaterialStats(frostRod, new IMaterialStats[]{new HandleMaterialStats(0.1f, -0.1f, -0.15f, 0.15f)});
            this.addMaterialStats(arcaneCloth, new IMaterialStats[]{StatlessMaterialStats.BINDING, StatlessMaterialStats.MAILLE, StatlessMaterialStats.BOWSTRING, new MagicClothMaterialStats(10.0f, 0.05f)});
            this.addMaterialStats(hogskin, new IMaterialStats[]{new MagicClothMaterialStats(8.0f, 0.0f)});
            this.addMaterialStats(dragonskin, new IMaterialStats[]{new MagicBaseMaterialStats(200.0f, -0.1f)});
            this.addMaterialStats(rainbowSlime, new IMaterialStats[0]);
            this.addMaterialStats(paper, new IMaterialStats[]{new MagicClothMaterialStats(8.0f, -0.15f)});
            this.addMaterialStats(leaf, new IMaterialStats[]{new MagicClothMaterialStats(6.0f, 0.15f)});
            this.addMaterialStats(MaterialIds.wood, new IMaterialStats[]{new MagicBaseMaterialStats(100.0f, 0.0f)});
            this.addMaterialStats(MaterialIds.bamboo, new IMaterialStats[]{new MagicBaseMaterialStats(100.0f, -0.05f)});
            this.addMaterialStats(MaterialIds.bone, new IMaterialStats[]{new MagicBaseMaterialStats(80.0f, 0.1f)});
            this.addMaterialStats(MaterialIds.nahuatl, new IMaterialStats[]{new MagicBaseMaterialStats(160.0f, -0.1f)});
            this.addMaterialStats(MaterialIds.chorus, new IMaterialStats[]{new MagicBaseMaterialStats(120.0f, 0.1f)});
            this.addMaterialStats(MaterialIds.necroticBone, new IMaterialStats[]{new MagicBaseMaterialStats(140.0f, -0.05f)});
            this.addMaterialStats(MaterialIds.blazingBone, new IMaterialStats[]{new MagicBaseMaterialStats(200.0f, 0.0f)});
            this.addMaterialStats(MaterialIds.leather, new IMaterialStats[]{new MagicClothMaterialStats(6.0f, 0.1f)});
            this.addMaterialStats(MaterialIds.roseGold, new IMaterialStats[]{new MagicClothMaterialStats(8.0f, -0.1f)});
            this.addMaterialStats(MaterialIds.ichorskin, new IMaterialStats[]{new MagicClothMaterialStats(8.0f, 0.05f)});
            crystalMaterials.forEach(materialId -> this.addMaterialStats((MaterialId)materialId, new IMaterialStats[]{CCMaterialStats.Statless.ADORNMENT}));
        }

        public String m_6055_() {
            return "Construct's Casting Material Stats";
        }
    }
}

