/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.materials;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.snackpirate.constructscasting.ConstructsCasting;
import com.snackpirate.constructscasting.materials.CCToolStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public record MagicBaseMaterialStats(float maxMana, float spellPower) implements IMaterialStats,
IRepairableMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(ConstructsCasting.id("magic_base"));
    public static final MaterialStatType<MagicBaseMaterialStats> TYPE = new MaterialStatType(ID, (IMaterialStats)new MagicBaseMaterialStats(0.0f, 0.0f), RecordLoadable.create((RecordField)FloatLoadable.ANY.defaultField("max_mana", (Object)Float.valueOf(0.0f), true, MagicBaseMaterialStats::maxMana), (RecordField)FloatLoadable.ANY.defaultField("spell_power", (Object)Float.valueOf(0.0f), true, MagicBaseMaterialStats::spellPower), MagicBaseMaterialStats::new));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)CCToolStats.MAX_MANA.getDescription(), (Object)CCToolStats.SPELL_POWER.getDescription());

    public MaterialStatType<?> getType() {
        return TYPE;
    }

    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(IToolStat.formatNumber((String)IMaterialStats.makeTooltipKey((ResourceLocation)ConstructsCasting.id("max_mana")), (TextColor)TextColor.m_131266_((int)5569788), (float)this.maxMana));
        info.add(IToolStat.formatColoredPercentBoost((String)IMaterialStats.makeTooltipKey((ResourceLocation)ConstructsCasting.id("spell_power")), (float)this.spellPower));
        return info;
    }

    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public void apply(ModifierStatsBuilder builder, float scale) {
        CCToolStats.MAX_MANA.add(builder, (double)(this.maxMana * scale));
        CCToolStats.SPELL_POWER.add(builder, this.spellPower * scale);
    }

    public int durability() {
        return 0;
    }
}

