/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.modifiers;

import com.snackpirate.constructscasting.modifiers.CCModifiers;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.modules.build.ModifierRequirementsModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class SpellbladeModifier
extends NoLevelsModifier
implements MeleeHitModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_HIT);
        hookBuilder.addModule((HookProvider)ModifierRequirementsModule.builder().requireModifier(CCModifiers.IMBUED.getId(), 1).translationKey("constructs_casting.modifier.spellblade.requirement").build());
    }

    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        String castingSlot;
        float ret = super.beforeMeleeHit(tool, modifier, context, damage, baseKnockback, knockback);
        Player player = context.getPlayerAttacker();
        InteractionHand interactionHand = context.getHand();
        if (player == null) {
            return ret;
        }
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (!ISpellContainer.isSpellContainer((ItemStack)itemStack)) {
            return ret;
        }
        ISpellContainer container = ISpellContainer.get((ItemStack)itemStack);
        if (container.isEmpty()) {
            return ret;
        }
        SpellData spellData = container.getSpellAtIndex(0);
        if (player.m_9236_().m_5776_()) {
            if (ClientMagicData.isCasting()) {
                return ret;
            }
            if (ClientMagicData.getPlayerMana() < spellData.getSpell().getManaCost(spellData.getLevel()) || ClientMagicData.getCooldowns().isOnCooldown(spellData.getSpell()) || !ClientMagicData.getSyncedSpellData((LivingEntity)player).isSpellLearned(spellData.getSpell())) {
                return ret;
            }
            return ret;
        }
        if (!context.isFullyCharged() || (float)spellData.getSpell().getEffectiveCastTime(spellData.getLevel(), (LivingEntity)player) > 60.0f / ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_SPEED)).floatValue() || spellData.getSpell().getCastType() == CastType.CONTINUOUS) {
            return ret;
        }
        String string = castingSlot = interactionHand.ordinal() == 0 ? SpellSelectionManager.MAINHAND : SpellSelectionManager.OFFHAND;
        if (spellData.getSpell().attemptInitiateCast(itemStack, spellData.getLevel(), player.m_9236_(), player, CastSource.SWORD, true, castingSlot)) {
            MagicData.getPlayerMagicData((LivingEntity)player).initiateCast(spellData.getSpell(), spellData.getLevel(), 0, CastSource.SWORD, castingSlot);
        }
        return ret;
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (context.getLivingTarget() != null) {
            context.getLivingTarget().f_19802_ = 0;
        }
    }

    public int getPriority() {
        return 150;
    }
}

