/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.spells;

import com.snackpirate.constructscasting.CCDamageTypes;
import com.snackpirate.constructscasting.CCSounds;
import com.snackpirate.constructscasting.ConstructsCasting;
import com.snackpirate.constructscasting.items.CCItems;
import com.snackpirate.constructscasting.spells.FreezeSpell;
import io.redspace.ironsspellbooks.api.attribute.MagicRangedAttribute;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CCSpells {
    public static final DeferredRegister<AbstractSpell> SPELLS = DeferredRegister.create((ResourceKey)SpellRegistry.SPELL_REGISTRY_KEY, (String)"constructs_casting");
    public static final RegistryObject<AbstractSpell> FREEZE_SPELL = CCSpells.registerSpell(new FreezeSpell());

    public static void register(IEventBus eventBus) {
        SPELLS.register(eventBus);
        Attributes.ATTRIBUTES.register(eventBus);
        Schools.SCHOOLS.register(eventBus);
    }

    public static RegistryObject<AbstractSpell> registerSpell(AbstractSpell spell) {
        return SPELLS.register(spell.getSpellName(), () -> spell);
    }

    @Mod.EventBusSubscriber(modid="constructs_casting", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Attributes {
        public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"constructs_casting");
        public static final RegistryObject<Attribute> SLIME_POWER = Attributes.newPowerAttribute("slime");
        public static final RegistryObject<Attribute> SLIME_RESIST = Attributes.newResistanceAttribute("slime");

        private static RegistryObject<Attribute> newResistanceAttribute(String id) {
            return ATTRIBUTES.register(id + "_magic_resist", () -> new MagicRangedAttribute("attribute.constructs_casting." + id + "_magic_resist", 1.0, -100.0, 100.0).m_22084_(true));
        }

        private static RegistryObject<Attribute> newPowerAttribute(String id) {
            return ATTRIBUTES.register(id + "_spell_power", () -> new MagicRangedAttribute("attribute.constructs_casting." + id + "_spell_power", 1.0, -100.0, 100.0).m_22084_(true));
        }

        @SubscribeEvent
        public static void modifyEntityAttributes(EntityAttributeModificationEvent e) {
            e.getTypes().forEach(entity -> ATTRIBUTES.getEntries().forEach(attribute -> e.add(entity, (Attribute)attribute.get())));
        }
    }

    public static class Schools {
        public static final DeferredRegister<SchoolType> SCHOOLS = DeferredRegister.create((ResourceKey)SchoolRegistry.SCHOOL_REGISTRY_KEY, (String)"constructs_casting");
        public static final ResourceLocation SLIME_LOC = ConstructsCasting.id("slime");
        public static final RegistryObject<SchoolType> SLIME = Schools.registerSchool(new SchoolType(SLIME_LOC, CCItems.Tags.SLIME_FOCUS, (Component)Component.m_237115_((String)"school.constructs_casting.slime").m_130948_(Style.f_131099_.m_178520_(1154107)), LazyOptional.of(() -> Attributes.SLIME_POWER.get()), LazyOptional.of(() -> Attributes.SLIME_RESIST.get()), LazyOptional.of(() -> (SoundEvent)CCSounds.SLIME_CAST.get()), CCDamageTypes.SLIME_MAGIC));

        private static RegistryObject<SchoolType> registerSchool(SchoolType schoolType) {
            return SCHOOLS.register(schoolType.getId().m_135815_(), () -> schoolType);
        }
    }
}

