/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.spells.slime.slimeball;

import com.snackpirate.constructscasting.ConstructsCasting;
import com.snackpirate.constructscasting.spells.CCSpells;
import com.snackpirate.constructscasting.spells.slime.slimeball.SlimeballProjectile;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class SlimeballSpell
extends AbstractSpell {
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(CCSpells.Schools.SLIME_LOC).setMaxLevel(10).setCooldownSeconds(1.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.constructs_casting.slimeball.max_bounces", (Object[])new Object[]{SlimeballSpell.getMaxBounces(spellLevel)}));
    }

    public SlimeballSpell() {
        this.manaCostPerLevel = 2;
        this.baseSpellPower = 6;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 10;
    }

    public SchoolType getSchoolType() {
        return (SchoolType)CCSpells.Schools.SLIME.get();
    }

    public ResourceLocation getSpellResource() {
        return ConstructsCasting.id("slimeball");
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        SlimeballProjectile slimeball = new SlimeballProjectile(level, (Entity)entity, spellLevel);
        slimeball.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - slimeball.m_20191_().m_82376_() * 0.5, 0.0));
        slimeball.m_20256_(entity.m_20154_().m_82490_((double)slimeball.getSpeed()).m_82549_(entity.m_20184_()));
        slimeball.setDamage(this.getDamage(spellLevel, entity));
        level.m_7967_((Entity)slimeball);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) * 0.5f;
    }

    public static int getMaxBounces(int spellLevel) {
        return spellLevel;
    }
}

