/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.leathered_boots.api;

import it.crystalnest.cobweb.api.registry.CobwebEntry;
import it.crystalnest.cobweb.api.registry.CobwebRegistry;
import it.crystalnest.leathered_boots.Constants;
import it.crystalnest.leathered_boots.item.LeatheredBootsItem;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5620;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LeatheredBootsManager {
    private static final ConcurrentHashMap<class_2960, CobwebEntry<LeatheredBootsItem>> LEATHERED_BOOTS = new ConcurrentHashMap();

    private LeatheredBootsManager() {
    }

    public static BootsRegister register(@NotNull String modId) {
        return new BootsRegister(modId);
    }

    public static List<LeatheredBootsItem> getBoots() {
        return LEATHERED_BOOTS.values().stream().map(Supplier::get).toList();
    }

    public static List<LeatheredBootsItem> getBoots(@NotNull String modId) {
        return LEATHERED_BOOTS.entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).method_12836().equalsIgnoreCase(modId)).map(entry -> (LeatheredBootsItem)((Object)((Object)((CobwebEntry)entry.getValue()).get()))).toList();
    }

    @Nullable
    public static LeatheredBootsItem getBoots(@NotNull class_2960 key) {
        return LEATHERED_BOOTS.containsKey(key) ? (LeatheredBootsItem)((Object)LEATHERED_BOOTS.get(key).get()) : null;
    }

    public static List<class_1799> getBootsStack() {
        return LEATHERED_BOOTS.values().stream().map(item -> ((LeatheredBootsItem)((Object)((Object)item.get()))).method_7854()).toList();
    }

    public static List<class_1799> getBootsStack(@NotNull String modId) {
        return LEATHERED_BOOTS.entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).method_12836().equalsIgnoreCase(modId)).map(entry -> ((LeatheredBootsItem)((Object)((Object)((CobwebEntry)entry.getValue()).get()))).method_7854()).toList();
    }

    @Nullable
    public static class_1799 getBootsStack(@NotNull class_2960 key) {
        LeatheredBootsItem item = LeatheredBootsManager.getBoots(key);
        return item == null ? null : item.method_7854();
    }

    public static List<String> getModIds() {
        return LEATHERED_BOOTS.keySet().stream().map(class_2960::method_12836).toList();
    }

    public record BootsRegister(String modId) {
        public synchronized CobwebEntry<LeatheredBootsItem> register(@NotNull String name, class_1741 armorMaterial, boolean isFireResistant, class_1814 rarity) {
            return this.register(name, (class_1792.class_1793 properties) -> new LeatheredBootsItem(BootsRegister.getLeatheredArmorMaterial(this.modId, armorMaterial), rarity, isFireResistant ? properties.method_24359() : properties));
        }

        public synchronized CobwebEntry<LeatheredBootsItem> register(@NotNull String name, class_1741 armorMaterial, boolean isFireResistant) {
            return this.register(name, (class_1792.class_1793 properties) -> new LeatheredBootsItem(BootsRegister.getLeatheredArmorMaterial(this.modId, armorMaterial), isFireResistant ? properties.method_24359() : properties));
        }

        private synchronized CobwebEntry<LeatheredBootsItem> register(@NotNull String name, Function<class_1792.class_1793, LeatheredBootsItem> constructor) {
            class_2960 id = class_2960.method_60655((String)this.modId, (String)("leathered_" + name + "_boots"));
            if (LEATHERED_BOOTS.containsKey(id)) {
                Constants.LOGGER.error("LeatheredBootsItem [{}] was already registered.", (Object)id);
            }
            return LEATHERED_BOOTS.computeIfAbsent(id, key -> CobwebRegistry.ofItems((String)this.modId).registerItem(key.method_12832(), properties -> {
                LeatheredBootsItem item = (LeatheredBootsItem)((Object)((Object)((Object)constructor.apply((class_1792.class_1793)properties))));
                class_5620.field_27776.comp_1982().putIfAbsent(item, class_5620::method_62711);
                return item;
            }));
        }

        public synchronized CobwebEntry<LeatheredBootsItem> register(@NotNull String name, class_1741 armorMaterial, class_1814 rarity) {
            return this.register(name, armorMaterial, false, rarity);
        }

        public synchronized CobwebEntry<LeatheredBootsItem> register(@NotNull String name, class_1741 armorMaterial) {
            return this.register(name, armorMaterial, false);
        }

        private static class_1741 getLeatheredArmorMaterial(String modId, class_1741 armorMaterial) {
            return new class_1741(armorMaterial.comp_3166(), armorMaterial.comp_2298(), armorMaterial.comp_3167(), armorMaterial.comp_2300(), armorMaterial.comp_2303(), armorMaterial.comp_2304(), armorMaterial.comp_2301(), class_5321.method_29179((class_5321)armorMaterial.comp_3168().method_58273(), (class_2960)class_2960.method_60655((String)modId, (String)("leathered_" + armorMaterial.comp_3168().method_29177().method_12832()))));
        }
    }
}

