/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.leathered_boots.api;

import it.crystalnest.cobweb.api.registry.CobwebEntry;
import it.crystalnest.cobweb.api.registry.CobwebRegistry;
import it.crystalnest.leathered_boots.Constants;
import it.crystalnest.leathered_boots.item.LeatheredBootsItem;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.equipment.ArmorMaterial;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LeatheredBootsManager {
    private static final ConcurrentHashMap<ResourceLocation, CobwebEntry<LeatheredBootsItem>> LEATHERED_BOOTS = new ConcurrentHashMap();

    private LeatheredBootsManager() {
    }

    public static BootsRegister register(@NotNull String modId) {
        return new BootsRegister(modId);
    }

    public static List<LeatheredBootsItem> getBoots() {
        return LEATHERED_BOOTS.values().stream().map(Supplier::get).toList();
    }

    public static List<LeatheredBootsItem> getBoots(@NotNull String modId) {
        return LEATHERED_BOOTS.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).getNamespace().equalsIgnoreCase(modId)).map(entry -> (LeatheredBootsItem)((Object)((Object)((CobwebEntry)entry.getValue()).get()))).toList();
    }

    @Nullable
    public static LeatheredBootsItem getBoots(@NotNull ResourceLocation key) {
        return LEATHERED_BOOTS.containsKey(key) ? (LeatheredBootsItem)((Object)LEATHERED_BOOTS.get(key).get()) : null;
    }

    public static List<ItemStack> getBootsStack() {
        return LEATHERED_BOOTS.values().stream().map(item -> ((LeatheredBootsItem)((Object)((Object)item.get()))).getDefaultInstance()).toList();
    }

    public static List<ItemStack> getBootsStack(@NotNull String modId) {
        return LEATHERED_BOOTS.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).getNamespace().equalsIgnoreCase(modId)).map(entry -> ((LeatheredBootsItem)((Object)((Object)((CobwebEntry)entry.getValue()).get()))).getDefaultInstance()).toList();
    }

    @Nullable
    public static ItemStack getBootsStack(@NotNull ResourceLocation key) {
        LeatheredBootsItem item = LeatheredBootsManager.getBoots(key);
        return item == null ? null : item.getDefaultInstance();
    }

    public static List<String> getModIds() {
        return LEATHERED_BOOTS.keySet().stream().map(ResourceLocation::getNamespace).toList();
    }

    public record BootsRegister(String modId) {
        public synchronized CobwebEntry<LeatheredBootsItem> register(@NotNull String name, ArmorMaterial armorMaterial, boolean isFireResistant, Rarity rarity) {
            return this.register(name, (Item.Properties properties) -> new LeatheredBootsItem(BootsRegister.getLeatheredArmorMaterial(this.modId, armorMaterial), rarity, isFireResistant ? properties.fireResistant() : properties));
        }

        public synchronized CobwebEntry<LeatheredBootsItem> register(@NotNull String name, ArmorMaterial armorMaterial, boolean isFireResistant) {
            return this.register(name, (Item.Properties properties) -> new LeatheredBootsItem(BootsRegister.getLeatheredArmorMaterial(this.modId, armorMaterial), isFireResistant ? properties.fireResistant() : properties));
        }

        private synchronized CobwebEntry<LeatheredBootsItem> register(@NotNull String name, Function<Item.Properties, LeatheredBootsItem> constructor) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("leathered_" + name + "_boots"));
            if (LEATHERED_BOOTS.containsKey(id)) {
                Constants.LOGGER.error("LeatheredBootsItem [{}] was already registered.", (Object)id);
            }
            return LEATHERED_BOOTS.computeIfAbsent(id, key -> CobwebRegistry.ofItems((String)this.modId).registerItem(key.getPath(), properties -> {
                LeatheredBootsItem item = (LeatheredBootsItem)((Object)((Object)((Object)constructor.apply((Item.Properties)properties))));
                CauldronInteraction.WATER.map().putIfAbsent(item, CauldronInteraction::dyedItemIteration);
                return item;
            }));
        }

        public synchronized CobwebEntry<LeatheredBootsItem> register(@NotNull String name, ArmorMaterial armorMaterial, Rarity rarity) {
            return this.register(name, armorMaterial, false, rarity);
        }

        public synchronized CobwebEntry<LeatheredBootsItem> register(@NotNull String name, ArmorMaterial armorMaterial) {
            return this.register(name, armorMaterial, false);
        }

        private static ArmorMaterial getLeatheredArmorMaterial(String modId, ArmorMaterial armorMaterial) {
            return new ArmorMaterial(armorMaterial.durability(), armorMaterial.defense(), armorMaterial.enchantmentValue(), armorMaterial.equipSound(), armorMaterial.toughness(), armorMaterial.knockbackResistance(), armorMaterial.repairIngredient(), ResourceKey.create((ResourceKey)armorMaterial.assetId().registryKey(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)("leathered_" + armorMaterial.assetId().location().getPath()))));
        }
    }
}

