/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.leathered_boots.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.crystalnest.leathered_boots.loot.BiomesCheck;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public final class ArchaeologyLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<ArchaeologyLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(instance -> ArchaeologyLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)Addition.CODEC.listOf().fieldOf("additions").forGetter(modifier -> modifier.additions)).and((App)Codec.FLOAT.fieldOf("chance_to_replace").forGetter(modifier -> modifier.chanceToReplace)).apply((Applicative)instance, ArchaeologyLootModifier::new)));
    private final List<Addition> additions;
    private final Float chanceToReplace;

    ArchaeologyLootModifier(LootItemCondition[] conditionsIn, List<Addition> additions, Float chanceToReplace) {
        super(conditionsIn);
        this.additions = additions;
        this.chanceToReplace = chanceToReplace;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        List<Item> items = this.additions.stream().filter(addition -> BiomesCheck.builder(addition.biomes).build().test((Object)context)).map(addition -> addition.item).toList();
        if (!items.isEmpty() && context.getRandom().nextFloat() <= this.chanceToReplace.floatValue()) {
            generatedLoot.clear();
            generatedLoot.add((Object)new ItemStack((ItemLike)items.get(context.getRandom().nextInt(0, items.size()))));
        }
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    private static final class Addition {
        public static final Codec<Addition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(addition -> addition.item), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).listOf().optionalFieldOf("biomes").forGetter(addition -> Optional.of(addition.biomes))).apply((Applicative)instance, Addition::new));
        private final Item item;
        private final List<ResourceKey<Biome>> biomes;

        private Addition(Item item, Optional<List<ResourceKey<Biome>>> biomes) {
            this.item = item;
            this.biomes = biomes.orElse(List.of());
        }
    }
}

