/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.leathered_boots.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.crystalnest.leathered_boots.loot.BiomesPredicate;
import it.crystalnest.leathered_boots.loot.CommonLootRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record BiomesCheck(BiomesPredicate predicate) implements LootItemCondition
{
    public static final MapCodec<BiomesCheck> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomesPredicate.CODEC.fieldOf("predicate").forGetter(BiomesCheck::predicate)).apply((Applicative)instance, BiomesCheck::new));

    public static LootItemCondition.Builder builder(List<ResourceKey<Biome>> biomes) {
        return () -> new BiomesCheck(new BiomesPredicate(biomes));
    }

    public static LootItemCondition.Builder builder(ResourceKey<Biome> biome) {
        return () -> new BiomesCheck(new BiomesPredicate(List.of(biome)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(LootContext context) {
        Object object = context.getOptionalParameter(LootContextParams.ORIGIN);
        if (!(object instanceof Vec3)) return false;
        Vec3 origin = (Vec3)object;
        if (!this.predicate.test(context.getLevel(), BlockPos.containing((Position)origin))) return false;
        return true;
    }

    @NotNull
    public LootItemConditionType getType() {
        return CommonLootRegistry.BIOMES_CHECK.get();
    }
}

