/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.leathered_boots.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;

public record BiomesPredicate(List<ResourceKey<Biome>> biomes) implements BiPredicate<ServerLevel, BlockPos>
{
    public static final Codec<BiomesPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.BIOME).listOf().fieldOf("biomes").forGetter(BiomesPredicate::biomes)).apply((Applicative)instance, BiomesPredicate::new));
    public static final BiomesPredicate ANY = new BiomesPredicate(List.of());

    @Override
    public boolean test(ServerLevel world, BlockPos pos) {
        return this.biomes.isEmpty() || world.isLoaded(pos) && this.biomes.stream().anyMatch(biome -> world.getBiome(pos).is(biome));
    }
}

