package snownee.jade.addon.core;

import java.text.DecimalFormat;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import snownee.jade.JadeClient;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.TextElement;
import snownee.jade.impl.theme.ThemeHelper;
import snownee.jade.util.NarrationHelper;

public abstract class DistanceProvider implements IToggleableProvider {

	public static class ForBlock extends DistanceProvider implements IBlockComponentProvider {
		public static final ForBlock INSTANCE = new ForBlock();

		@Override
		public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
			append(tooltip, accessor, accessor.getPosition(), config);
		}
	}

	public static class ForEntity extends DistanceProvider implements IEntityComponentProvider {
		public static final ForEntity INSTANCE = new ForEntity();

		@Override
		public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
			append(tooltip, accessor, accessor.getEntity().blockPosition(), config);
		}
	}

	public static final DecimalFormat fmt = new DecimalFormat("#.#");
	private static final int[] colors = {0xef9a9a, 0xa5d6a7, 0x90caf9, 0xb02a37, 0x198754, 0x0a58ca};

	public static String distance(Accessor<?> accessor) {
		float partialTick = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true);
		return fmt.format(accessor.getPlayer().getEyePosition(partialTick).distanceTo(accessor.getHitResult().getLocation()));
	}

	public static TextElement xyz(Vec3i pos) {
		Component display = Component.translatable("jade.blockpos", display(pos.getX(), 0), display(pos.getY(), 1), display(pos.getZ(), 2));
		String narration = JadeClient.formatString(
				"narration.jade.blockpos",
				NarrationHelper.number(pos.getX()),
				NarrationHelper.number(pos.getY()),
				NarrationHelper.number(pos.getZ()));
		TextElement text = JadeUI.text(display);
		text.narration(narration);
		return text;
	}

	public static Component display(int i, int colorIndex) {
		if (IThemeHelper.get().isLightColorScheme()) {
			colorIndex += 3;
		}
		return Component.literal(Integer.toString(i)).withStyle(ThemeHelper.colorStyle(colors[colorIndex]));
	}

	public void append(ITooltip tooltip, Accessor<?> accessor, BlockPos pos, IPluginConfig config) {
		boolean distance = config.get(JadeIds.CORE_DISTANCE);
		String distanceVal = distance ? distance(accessor) : null;
		String distanceMsg = distance ? JadeClient.formatString("narration.jade.distance", distanceVal) : null;
		if (config.get(JadeIds.CORE_COORDINATES)) {
			if (config.get(JadeIds.CORE_REL_COORDINATES) && JadeUI.hasControlDown()) {
				tooltip.add(xyz(pos.subtract(BlockPos.containing(accessor.getPlayer().getEyePosition()))));
			} else {
				tooltip.add(xyz(pos));
			}
			if (distance) {
				tooltip.append(JadeUI
						.text(Component.translatable("jade.distance1", distanceVal))
						.narration(distanceMsg));
			}
		} else if (distance) {
			tooltip.add(JadeUI
					.text(Component.translatable("jade.distance2", distanceVal))
					.narration(distanceMsg));
		}
	}

	@Override
	public Identifier getUid() {
		return JadeIds.CORE_DISTANCE;
	}

	@Override
	public boolean isRequired() {
		return true;
	}

	@Override
	public int getDefaultPriority() {
		return -4600;
	}

}
