package snownee.jade.addon.vanilla;

import org.jspecify.annotations.Nullable;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;

public class CommandBlockProvider implements StreamServerDataProvider<BlockAccessor, String> {
	public static final CommandBlockProvider INSTANCE = new CommandBlockProvider();

	@Override
	@Nullable
	public String streamData(BlockAccessor accessor) {
		if (!accessor.getPlayer().canUseGameMasterBlocks()) {
			return null;
		}
		String command = accessor.<CommandBlockEntity>typedBlockEntity().getCommandBlock().getCommand();
		if (command.length() > 40) {
			command = command.substring(0, 37) + "...";
		}
		return command;
	}

	@Override
	public StreamCodec<RegistryFriendlyByteBuf, String> streamCodec() {
		return ByteBufCodecs.STRING_UTF8.cast();
	}

	@Override
	public boolean shouldRequestData(BlockAccessor accessor) {
		return accessor.getPlayer().canUseGameMasterBlocks();
	}

	@Override
	public Identifier getUid() {
		return JadeIds.MC_COMMAND_BLOCK;
	}

	public static class Client implements IBlockComponentProvider {
		public static final Client INSTANCE = new Client();

		@Override
		public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
			String command = CommandBlockProvider.INSTANCE.decodeFromData(accessor).orElse("");
			if (command.isBlank()) {
				return;
			}
			tooltip.add(Component.literal("> " + command));
		}

		@Override
		public Identifier getUid() {
			return JadeIds.MC_COMMAND_BLOCK;
		}
	}
}
