package snownee.jade.impl.ui;

import java.util.Objects;

import org.jspecify.annotations.Nullable;

import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.FluidInput;

public class FluidStackElement extends ProgressOverlayElement {

	private final JadeFluidObject fluid;

	public FluidStackElement(JadeFluidObject fluid) {
		this.fluid = Objects.requireNonNull(fluid);
		width = height = 16;
	}

	@Override
	public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
		if (floatingRect == null) {
			DisplayHelper.INSTANCE.drawFluid(graphics, getX(), getY(), fluid, width, height, JadeFluidObject.bucketVolume());
		} else {
			DisplayHelper.INSTANCE.drawFluid(
					graphics,
					floatingRect.getX(),
					floatingRect.getY(),
					fluid,
					floatingRect.getWidth(),
					floatingRect.getHeight(),
					JadeFluidObject.bucketVolume());
		}
	}

	@Override
	public @Nullable Component getNarration() {
		return null;
	}

	@Override
	public boolean copyToClipboard(KeyboardHandler keyboardHandler) {
		ClientPacketListener connection = Minecraft.getInstance().getConnection();
		if (connection == null) {
			return false;
		}
		keyboardHandler.setClipboard(new FluidInput(fluid).serialize(connection.registryAccess()));
		return true;
	}
}
