package snownee.jade.test;

import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import snownee.jade.api.Accessor;
import snownee.jade.api.ui.MessageType;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public enum ExampleItemStorageProvider implements IServerExtensionProvider<ItemStack>, IClientExtensionProvider<ItemStack, ItemView> {
	INSTANCE;

	@Override
	public Identifier getUid() {
		return ExamplePlugin.UID_TEST_BREWING;
	}

	@Override
	public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> groups) {
		return ClientViewGroup.map(
				groups, ItemView::new, (group, clientGroup) -> {
					clientGroup.title = Component.literal(Objects.requireNonNull(group.id));
					clientGroup.messageType = MessageType.WARNING;
				});
	}

	@Override
	public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor) {
		BrewingStandBlockEntity target = (BrewingStandBlockEntity) Objects.requireNonNull(accessor.getTarget());
		var potions = new ViewGroup<>(IntStream.of(0, 1, 2).mapToObj(target::getItem).filter($ -> !$.isEmpty()).toList());
		potions.id = "Potions";
		var ingredient = new ViewGroup<>(IntStream.of(3).mapToObj(target::getItem).filter($ -> !$.isEmpty()).toList());
		ingredient.id = "Ingredient";
		return List.of(ingredient, potions);
	}
}
