/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import com.mojang.datafixers.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_11573;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1548;
import net.minecraft.class_1621;
import net.minecraft.class_1641;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4466;
import net.minecraft.class_5250;
import net.minecraft.class_5955;
import net.minecraft.class_6053;
import net.minecraft.class_9851;
import snownee.jade.JadeClient;
import snownee.jade.addon.access.AccessibilityPlugin;
import snownee.jade.addon.access.EntityVariantHelper;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.util.CommonProxy;

public class EntityDetailsProvider
implements IEntityComponentProvider {
    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Either<String, class_2561> color;
        class_1308 mob;
        class_9851 shearable;
        class_1309 livingEntity;
        class_1297 entity = accessor.getEntity();
        String objectName = tooltip.getString(JadeIds.CORE_OBJECT_NAME);
        class_1297 class_12972 = entity;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1548.class, class_1528.class, class_1641.class, class_6053.class, class_4466.class, class_1621.class, class_11573.class}, (Object)class_12973, n)) {
                case 0: {
                    class_1548 creeper = (class_1548)class_12973;
                    if (!creeper.method_61492()) {
                        n = 1;
                        continue block9;
                    }
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "creeper.powered");
                    break block9;
                }
                case 1: {
                    class_1528 witherBoss = (class_1528)class_12973;
                    if (!witherBoss.method_6872()) {
                        n = 2;
                        continue block9;
                    }
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "wither.powered");
                    break block9;
                }
                case 2: {
                    class_1641 zombieVillager = (class_1641)class_12973;
                    if (!zombieVillager.method_7198()) {
                        n = 3;
                        continue block9;
                    }
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "zombie_villager.curing");
                    break block9;
                }
                case 3: {
                    class_6053 goat = (class_6053)class_12973;
                    if (goat.method_43538() || goat.method_43539()) {
                        n = 4;
                        continue block9;
                    }
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "goat.hornless");
                    break block9;
                }
                case 4: {
                    class_4466 bee = (class_4466)class_12973;
                    if (bee.method_21784()) {
                        AccessibilityPlugin.replaceTitle(tooltip, objectName, "bee.nectar");
                    }
                    if (!bee.method_29511()) break block9;
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.angry");
                    break block9;
                }
                case 5: {
                    class_1621 slime = (class_1621)class_12973;
                    String message = tooltip.getString(JadeIds.CORE_OBJECT_NAME);
                    class_5250 title = IThemeHelper.get().title(JadeClient.format("jade.access.slime.size", message, slime.method_7152()));
                    tooltip.replace(JadeIds.CORE_OBJECT_NAME, (class_2561)title);
                    break block9;
                }
                case 6: {
                    class_11573 golem = (class_11573)class_12973;
                    class_5955.class_5811 state = golem.method_72477();
                    if (state == class_5955.class_5811.field_28704) break block9;
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity." + state.method_15434());
                    break block9;
                }
            }
            break;
        }
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_6109()) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.baby");
        }
        if ((shearable = CommonProxy.isShearable(entity)) != class_9851.field_52396) {
            if (entity instanceof class_11573) {
                if (shearable == class_9851.field_52394) {
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.shearable");
                }
            } else if (shearable == class_9851.field_52395) {
                AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.sheared");
            }
        }
        if (entity instanceof class_1308 && (mob = (class_1308)entity).method_66672()) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.saddled");
        }
        if ((color = EntityVariantHelper.getVariantName(entity, true)) != null) {
            color.ifLeft(s -> AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity." + s));
        }
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.ACCESS_ENTITY_DETAILS;
    }

    @Override
    public int getDefaultPriority() {
        return ObjectNameProvider.ForEntity.INSTANCE.getDefaultPriority() + 10;
    }
}

