/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.network.ServerPayloadContext;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class EntityAccessorImpl
extends AccessorImpl<class_3966>
implements EntityAccessor {
    private final Supplier<class_1297> entity;

    public EntityAccessorImpl(Builder builder) {
        super(Objects.requireNonNull(builder.level), Objects.requireNonNull(builder.player), builder.serverData, Objects.requireNonNull(builder.hit), builder.connected, builder.showDetails);
        this.entity = Objects.requireNonNull(builder.entity);
    }

    public static void handleRequest(RequestEntityPacket message, ServerPayloadContext context, Consumer<class_2487> responseSender) {
        class_3222 player = context.player();
        context.execute(() -> {
            EntityAccessor accessor = message.data().unpack(player);
            if (accessor == null) {
                return;
            }
            class_1297 entity = accessor.getEntity();
            double maxDistance = class_3532.method_33723((double)(player.method_55755() + 21.0));
            if (player.method_5858(entity) > maxDistance) {
                return;
            }
            List<IServerDataProvider<EntityAccessor>> providers = WailaCommonRegistration.instance().entityDataProvidersOf(entity);
            class_2487 tag = accessor.getServerData();
            for (IServerDataProvider<EntityAccessor> provider : providers) {
                if (!message.dataProviders().contains(provider)) continue;
                try {
                    provider.appendServerData(tag, accessor);
                }
                catch (Exception e) {
                    WailaExceptionHandler.handleErr(e, provider, null);
                }
            }
            tag.method_10569("EntityId", entity.method_5628());
            responseSender.accept(tag);
        });
    }

    @Override
    public class_1297 getEntity() {
        return CommonProxy.wrapPartEntityParent(this.getRawEntity());
    }

    @Override
    public class_1297 getRawEntity() {
        return this.entity.get();
    }

    @Override
    public class_1799 getPickedResult() {
        if (this.isServersideContent()) {
            return this.getServersideRep();
        }
        return CommonProxy.getEntityPickedResult(this.entity.get(), this.getPlayer(), (class_3966)this.getHitResult());
    }

    @Override
    public Object getTarget() {
        return this.getEntity();
    }

    @Override
    public boolean verifyData(class_2487 data) {
        if (!this.verify) {
            return true;
        }
        return data.method_10550("EntityId").filter(id -> id.intValue() == this.getEntity().method_5628()).isPresent();
    }

    public static class Builder
    implements EntityAccessor.Builder {
        public boolean showDetails;
        private @Nullable class_1937 level;
        private @Nullable class_1657 player;
        private @Nullable class_2487 serverData;
        private boolean connected;
        private @Nullable Supplier<class_3966> hit;
        private @Nullable Supplier<class_1297> entity;
        private boolean verify;

        @Override
        public Builder level(class_1937 level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(class_1657 player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(@Nullable class_2487 serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(Supplier<class_3966> hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder entity(Supplier<class_1297> entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder from(EntityAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData().method_10553();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = accessor::getHitResult;
            this.entity = accessor::getEntity;
            this.verify = accessor.shouldVerifyData();
            return this;
        }

        @Override
        public EntityAccessor.Builder requireVerification(boolean verify) {
            this.verify = verify;
            return this;
        }

        @Override
        public EntityAccessor build() {
            EntityAccessorImpl accessor = new EntityAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }

    public record SyncData(boolean showDetails, int id, int partIndex, class_243 hitVec, class_2487 data) {
        public static final class_9139<class_9129, SyncData> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_48547, SyncData::showDetails, (class_9139)class_9135.field_48550, SyncData::id, (class_9139)class_9135.field_48550, SyncData::partIndex, (class_9139)class_9135.field_48558.method_56432(class_243::new, class_243::method_46409), SyncData::hitVec, (class_9139)class_9135.field_48556, SyncData::data, SyncData::new);

        public SyncData(EntityAccessor accessor) {
            this(accessor.showDetails(), accessor.getEntity().method_5628(), CommonProxy.getPartEntityIndex(accessor.getRawEntity()), ((class_3966)accessor.getHitResult()).method_17784(), accessor.getServerData());
        }

        public @Nullable EntityAccessor unpack(class_3222 player) {
            class_1297 entity = CommonProxy.getPartEntity(player.method_51469().method_8469(this.id), this.partIndex);
            if (entity == null) {
                return null;
            }
            return ((Builder)((Builder)new Builder().level((class_1937)player.method_51469()).player((class_1657)player).showDetails(this.showDetails).entity(() -> entity)).hit((Supplier)Suppliers.memoize(() -> new class_3966(entity, this.hitVec)))).serverData(this.data).build();
        }
    }
}

