/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config.entry;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.OptionValue;

public abstract class ConfigEntry<T> {
    protected final class_2960 id;
    private final T defaultValue;
    private @Nullable T syncedValue;
    private List<Consumer<class_2960>> listeners = List.of();

    public ConfigEntry(class_2960 id, T defaultValue) {
        this.id = id;
        this.defaultValue = defaultValue;
    }

    public class_2960 id() {
        return this.id;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public T syncedValue() {
        return Objects.requireNonNull(this.syncedValue);
    }

    public boolean isSynced() {
        return this.syncedValue != null;
    }

    public void setSyncedValue(@Nullable T value) {
        this.syncedValue = value;
    }

    public T convertValue(Object value) {
        return (T)value;
    }

    public abstract boolean isValidValue(Object var1);

    public abstract OptionValue<?> createUI(OptionsList var1, String var2, IPluginConfig var3, BiConsumer<class_2960, Object> var4);

    public void addListener(Consumer<class_2960> listener) {
        if (this.listeners.isEmpty()) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void notifyChange() {
        for (Consumer<class_2960> listener : this.listeners) {
            listener.accept(this.id);
        }
    }
}

