/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.FlowerBedBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import snownee.jade.addon.core.BlockFaceProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;

public class BlockDetailsBodyProvider
implements IBlockComponentProvider {
    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState blockState = accessor.getBlockState();
        Block block = blockState.getBlock();
        if (block instanceof RedStoneWireBlock) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)4);
            for (Map.Entry entry : RedStoneWireBlock.PROPERTY_BY_DIRECTION.entrySet()) {
                RedstoneSide side = (RedstoneSide)blockState.getValue((Property)entry.getValue());
                if (side == RedstoneSide.NONE) continue;
                list.add(BlockFaceProvider.directionName((Direction)entry.getKey()));
            }
            if (list.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"jade.access.block.redstone_wire.dot"));
            } else {
                tooltip.add((Component)Component.translatable((String)"jade.access.block.redstone_wire", (Object[])new Object[]{ComponentUtils.formatList((Collection)list, (Component)ComponentUtils.DEFAULT_NO_STYLE_SEPARATOR)}));
            }
            return;
        }
        if (block instanceof FlowerBedBlock || block instanceof CampfireBlock || block instanceof DecoratedPotBlock || block instanceof SmallDripleafBlock || block instanceof BigDripleafBlock || block instanceof BigDripleafStemBlock) {
            return;
        }
        RailShape railShape = null;
        if (blockState.hasProperty((Property)BlockStateProperties.RAIL_SHAPE)) {
            railShape = (RailShape)blockState.getValue((Property)BlockStateProperties.RAIL_SHAPE);
        } else if (blockState.hasProperty((Property)BlockStateProperties.RAIL_SHAPE_STRAIGHT)) {
            railShape = (RailShape)blockState.getValue((Property)BlockStateProperties.RAIL_SHAPE_STRAIGHT);
        }
        if (railShape != null) {
            tooltip.add((Component)Component.translatable((String)"jade.access.block.rail.%s".formatted(railShape.getSerializedName())));
        }
        Direction facing = null;
        if (blockState.hasProperty((Property)BlockStateProperties.FACING)) {
            facing = (Direction)blockState.getValue((Property)BlockStateProperties.FACING);
        } else if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            facing = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        } else if (blockState.hasProperty((Property)BlockStateProperties.FACING_HOPPER)) {
            facing = (Direction)blockState.getValue((Property)BlockStateProperties.FACING_HOPPER);
        }
        if (facing != null) {
            tooltip.add((Component)Component.translatable((String)"jade.access.block.facing", (Object[])new Object[]{BlockFaceProvider.directionName(facing)}));
        }
    }

    @Override
    public Identifier getUid() {
        return JadeIds.ACCESS_BLOCK_DETAILS_BODY;
    }

    @Override
    public boolean isRequired() {
        return true;
    }
}

