/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import com.mojang.datafixers.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.util.TriState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.bee.Bee;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.golem.CopperGolem;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.zombie.ZombieVillager;
import net.minecraft.world.level.block.WeatheringCopper;
import snownee.jade.JadeClient;
import snownee.jade.addon.access.AccessibilityPlugin;
import snownee.jade.addon.access.EntityVariantHelper;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.util.CommonProxy;

public class EntityDetailsProvider
implements IEntityComponentProvider {
    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Either<String, Component> color;
        Mob mob;
        TriState shearable;
        LivingEntity livingEntity;
        Entity entity = accessor.getEntity();
        String objectName = tooltip.getString(JadeIds.CORE_OBJECT_NAME);
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Creeper.class, WitherBoss.class, ZombieVillager.class, Goat.class, Bee.class, Slime.class, CopperGolem.class}, (Object)entity3, n)) {
                case 0: {
                    Creeper creeper = (Creeper)entity3;
                    if (!creeper.isPowered()) {
                        n = 1;
                        continue block9;
                    }
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "creeper.powered");
                    break block9;
                }
                case 1: {
                    WitherBoss witherBoss = (WitherBoss)entity3;
                    if (!witherBoss.isPowered()) {
                        n = 2;
                        continue block9;
                    }
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "wither.powered");
                    break block9;
                }
                case 2: {
                    ZombieVillager zombieVillager = (ZombieVillager)entity3;
                    if (!zombieVillager.isConverting()) {
                        n = 3;
                        continue block9;
                    }
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "zombie_villager.curing");
                    break block9;
                }
                case 3: {
                    Goat goat = (Goat)entity3;
                    if (goat.hasLeftHorn() || goat.hasRightHorn()) {
                        n = 4;
                        continue block9;
                    }
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "goat.hornless");
                    break block9;
                }
                case 4: {
                    Bee bee = (Bee)entity3;
                    if (bee.hasNectar()) {
                        AccessibilityPlugin.replaceTitle(tooltip, objectName, "bee.nectar");
                    }
                    if (!bee.isAngry()) break block9;
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.angry");
                    break block9;
                }
                case 5: {
                    Slime slime = (Slime)entity3;
                    String message = tooltip.getString(JadeIds.CORE_OBJECT_NAME);
                    MutableComponent title = IThemeHelper.get().title(JadeClient.format("jade.access.slime.size", message, slime.getSize()));
                    tooltip.replace(JadeIds.CORE_OBJECT_NAME, (Component)title);
                    break block9;
                }
                case 6: {
                    CopperGolem golem = (CopperGolem)entity3;
                    WeatheringCopper.WeatherState state = golem.getWeatherState();
                    if (state == WeatheringCopper.WeatherState.UNAFFECTED) break block9;
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity." + state.getSerializedName());
                    break block9;
                }
            }
            break;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isBaby()) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.baby");
        }
        if ((shearable = CommonProxy.isShearable(entity)) != TriState.DEFAULT) {
            if (entity instanceof CopperGolem) {
                if (shearable == TriState.TRUE) {
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.shearable");
                }
            } else if (shearable == TriState.FALSE) {
                AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.sheared");
            }
        }
        if (entity instanceof Mob && (mob = (Mob)entity).isSaddled()) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.saddled");
        }
        if ((color = EntityVariantHelper.getVariantName(entity, true)) != null) {
            color.ifLeft(s -> AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity." + s));
        }
    }

    @Override
    public Identifier getUid() {
        return JadeIds.ACCESS_ENTITY_DETAILS;
    }

    @Override
    public int getDefaultPriority() {
        return ObjectNameProvider.ForEntity.INSTANCE.getDefaultPriority() + 10;
    }
}

