/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.JadeUI;

public class BrewingStandProvider
implements StreamServerDataProvider<BlockAccessor, Data> {
    public static final BrewingStandProvider INSTANCE = new BrewingStandProvider();

    @Override
    public Data streamData(BlockAccessor accessor) {
        BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)accessor.typedBlockEntity();
        return new Data(brewingStand.fuel, brewingStand.brewTime);
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
        return Data.STREAM_CODEC.cast();
    }

    @Override
    public Identifier getUid() {
        return JadeIds.MC_BREWING_STAND;
    }

    public record Data(int fuel, int time) {
        public static final StreamCodec<ByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Data::fuel, (StreamCodec)ByteBufCodecs.VAR_INT, Data::time, Data::new);
    }

    public static class Client
    implements IBlockComponentProvider {
        public static final Client INSTANCE = new Client();

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            Data data = INSTANCE.decodeFromData(accessor).orElse(null);
            if (data == null) {
                return;
            }
            tooltip.add(JadeUI.smallItem(new ItemStack((ItemLike)Items.BLAZE_POWDER)).narration(""));
            tooltip.append(JadeUI.text((Component)IThemeHelper.get().info(data.fuel)).narration((Component)Component.translatable((String)"narration.jade.brewingStand.fuel", (Object[])new Object[]{data.fuel})));
            if (data.time > 0) {
                tooltip.append(JadeUI.spacer(5, 0));
                tooltip.append(JadeUI.smallItem(new ItemStack((ItemLike)Items.CLOCK)).narration(""));
                tooltip.append((Component)IThemeHelper.get().seconds(data.time, accessor.tickRate()));
            }
        }

        @Override
        public Identifier getUid() {
            return JadeIds.MC_BREWING_STAND;
        }
    }
}

