/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.JadeUI;

public class LecternProvider
implements StreamServerDataProvider<BlockAccessor, ItemStack> {
    public static final LecternProvider INSTANCE = new LecternProvider();

    @Override
    public boolean shouldRequestData(BlockAccessor accessor) {
        return (Boolean)accessor.getBlockState().getValue((Property)LecternBlock.HAS_BOOK);
    }

    @Override
    public ItemStack streamData(BlockAccessor accessor) {
        return ((LecternBlockEntity)accessor.typedBlockEntity()).getBook();
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ItemStack> streamCodec() {
        return ItemStack.OPTIONAL_STREAM_CODEC;
    }

    @Override
    public Identifier getUid() {
        return JadeIds.MC_LECTERN;
    }

    public static class Client
    implements IBlockComponentProvider {
        public static final Client INSTANCE = new Client();

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            ItemStack stack = INSTANCE.decodeFromData(accessor).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) {
                return;
            }
            tooltip.add(JadeUI.smallItem(stack));
            tooltip.append(JadeUI.text((Component)IDisplayHelper.get().stripColor(stack.getHoverName())).narration((Component)Component.translatable((String)"narration.jade.bookName", (Object[])new Object[]{stack.getHoverName()})));
        }

        @Override
        public Identifier getUid() {
            return JadeIds.MC_LECTERN;
        }
    }
}

