/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.JadeMobEffectInstance;

public class StatusEffectsProvider
implements StreamServerDataProvider<EntityAccessor, List<Effect>> {
    public static final StatusEffectsProvider INSTANCE = new StatusEffectsProvider();
    private static final StreamCodec<RegistryFriendlyByteBuf, List<Effect>> STREAM_CODEC = ByteBufCodecs.list().apply(Effect.STREAM_CODEC);

    @Override
    public boolean shouldRequestData(EntityAccessor accessor) {
        return accessor.getEntity() instanceof LivingEntity;
    }

    @Override
    public @Nullable List<Effect> streamData(EntityAccessor accessor) {
        List<Effect> effects = ((LivingEntity)accessor.getEntity()).getActiveEffects().stream().filter(MobEffectInstance::isVisible).filter(Predicate.not(WailaCommonRegistration.instance().mobEffectOperations()::shouldHide)).map(Effect::new).toList();
        return effects.isEmpty() ? null : effects;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, List<Effect>> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public Identifier getUid() {
        return JadeIds.MC_POTION_EFFECTS;
    }

    public record Effect(MobEffectInstance effect, long updateTime, long addTime) implements Comparable<Effect>
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Effect> STREAM_CODEC = StreamCodec.composite((StreamCodec)MobEffectInstance.STREAM_CODEC, Effect::effect, (StreamCodec)ByteBufCodecs.LONG, Effect::updateTime, (StreamCodec)ByteBufCodecs.LONG, Effect::addTime, Effect::new);

        public Effect(MobEffectInstance effect) {
            this(effect, ((JadeMobEffectInstance)effect).jade$updateTime(), ((JadeMobEffectInstance)effect).jade$addTime());
        }

        @Override
        public int compareTo(Effect o) {
            int compared = Long.compare(this.updateTime, o.updateTime);
            if (compared != 0) {
                return -compared;
            }
            return this.effect.compareTo(o.effect);
        }
    }

    public static class Client
    implements IEntityComponentProvider {
        public static final Client INSTANCE = new Client();
        public static final Component INFINITE = Component.translatable((String)"effect.duration.infinite");

        public static MutableComponent getEffectName(MobEffectInstance mobEffectInstance) {
            MutableComponent mutableComponent = ((MobEffect)mobEffectInstance.getEffect().value()).getDisplayName().copy();
            if (mobEffectInstance.getAmplifier() >= 1) {
                MutableComponent level = Component.translatable((String)("enchantment.level." + (mobEffectInstance.getAmplifier() + 1)));
                if (!ComponentUtils.isTranslationResolvable((Component)level)) {
                    level = Component.literal((String)Integer.toString(mobEffectInstance.getAmplifier() + 1));
                }
                mutableComponent.append(CommonComponents.SPACE).append((Component)level);
            }
            return mutableComponent;
        }

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            List<Object> effects = INSTANCE.decodeFromData(accessor).orElse(List.of());
            if (effects.isEmpty()) {
                return;
            }
            ITooltip box = JadeUI.tooltip();
            IThemeHelper t = IThemeHelper.get();
            long current = System.currentTimeMillis();
            float scale = (effects = effects.stream().filter($ -> {
                if (WailaCommonRegistration.instance().mobEffectOperations().shouldHide($.effect())) {
                    return false;
                }
                long ms = current - $.addTime() - 20L;
                return ms > 0L;
            }).sorted().limit(config.getInt(JadeIds.MC_POTION_EFFECTS_LIMIT)).toList()).size() > 2 ? 0.75f : 1.0f;
            boolean animation = IWailaConfig.get().overlay().getAnimation();
            for (Effect data : effects) {
                long ms = current - data.addTime() - 20L;
                float alpha = 1.0f;
                if (animation && ms < 480L) {
                    alpha = (float)ms / 480.0f;
                }
                MobEffectInstance effect = data.effect();
                MutableComponent name = Client.getEffectName(effect);
                String duration = effect.isInfiniteDuration() ? INFINITE.getString() : StringUtil.formatTickDuration((int)effect.getDuration(), (float)accessor.tickRate());
                MutableComponent s = Component.translatable((String)"jade.potion", (Object[])new Object[]{name, duration});
                s = switch (((MobEffect)effect.getEffect().value()).getCategory()) {
                    default -> throw new MatchException(null, null);
                    case MobEffectCategory.BENEFICIAL -> t.success(s);
                    case MobEffectCategory.HARMFUL -> t.danger(s);
                    case MobEffectCategory.NEUTRAL -> t.info(s);
                };
                box.add(JadeUI.text((Component)s).scale(scale).alpha(alpha));
            }
            tooltip.add(JadeUI.box(box, BoxStyle.nestedBox()).flexGrow(1));
        }

        @Override
        public Identifier getUid() {
            return JadeIds.MC_POTION_EFFECTS;
        }
    }
}

