/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.monster.zombie.ZombieVillager;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.npc.villager.VillagerData;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;

public class VillagerProfessionProvider
implements IEntityComponentProvider {
    public static final VillagerProfessionProvider INSTANCE = new VillagerProfessionProvider();
    private static final Component LEVEL_SEPARATOR = Component.literal((String)" - ");

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        VillagerData data = null;
        if (accessor.getEntity() instanceof Villager) {
            data = ((Villager)accessor.getEntity()).getVillagerData();
        } else if (accessor.getEntity() instanceof ZombieVillager) {
            data = ((ZombieVillager)accessor.getEntity()).getVillagerData();
        }
        if (data == null) {
            return;
        }
        int level = data.level();
        VillagerProfession profession = (VillagerProfession)data.profession().value();
        MutableComponent component = profession.name().copy();
        if (profession.workSound() != null && level >= 1 && level <= 5) {
            component.append(LEVEL_SEPARATOR).append((Component)Component.translatable((String)("merchant.level." + level)));
        }
        tooltip.add((Component)component);
    }

    @Override
    public Identifier getUid() {
        return JadeIds.MC_VILLAGER_PROFESSION;
    }
}

