/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.Accessor;

public interface BlockAccessor
extends Accessor<BlockHitResult> {
    public Block getBlock();

    public BlockState getBlockState();

    public @Nullable BlockEntity getBlockEntity();

    default public <T extends BlockEntity> T typedBlockEntity() {
        BlockEntity blockEntity = this.getBlockEntity();
        return (T)Objects.requireNonNull(blockEntity);
    }

    public BlockPos getPosition();

    public Direction getSide();

    @Override
    default public Class<? extends Accessor<?>> getAccessorType() {
        return BlockAccessor.class;
    }

    @ApiStatus.NonExtendable
    public static interface Builder {
        public Builder level(Level var1);

        public Builder player(Player var1);

        public Builder serverData(@Nullable CompoundTag var1);

        public Builder serverConnected(boolean var1);

        public Builder showDetails(boolean var1);

        public Builder hit(BlockHitResult var1);

        public Builder blockState(BlockState var1);

        default public Builder blockEntity(@Nullable BlockEntity blockEntity) {
            return this.blockEntity(() -> blockEntity);
        }

        public Builder blockEntity(Supplier<@Nullable BlockEntity> var1);

        public Builder serversideRep(ItemStack var1);

        public Builder from(BlockAccessor var1);

        default public Builder requireVerification() {
            return this.requireVerification(true);
        }

        public Builder requireVerification(boolean var1);

        public BlockAccessor build();
    }
}

