/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.theme;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;
import snownee.jade.api.JadeIds;
import snownee.jade.api.ui.BoxElement;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.overlay.OverlayRenderer;

public interface SneakyDetails {
    public static final SneakyDetails DEFAULT = new Simple(JadeIds.JADE("details_arrow"), 7, 5, 0.0f, 0.0f, "breath", 1.0f, 12.0f);
    public static final Codec<SneakyDetails> CODEC = Codec.STRING.dispatch(SneakyDetails::type, SneakyDetails::codec);

    public static MapCodec<? extends SneakyDetails> codec(String s) {
        if ("simple".equals(s)) {
            return Simple.CODEC;
        }
        throw new UnsupportedOperationException();
    }

    public void render(GuiGraphics var1, float var2, BoxElement var3);

    public String type();

    public record Simple(Identifier sprite, int width, int height, float offsetX, float offsetY, String animation, float animationDistance, float animationPeriod) implements SneakyDetails
    {
        public static final MapCodec<Simple> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Identifier.CODEC.fieldOf("sprite").forGetter(Simple::sprite), (App)Codec.INT.fieldOf("width").forGetter(Simple::width), (App)Codec.INT.fieldOf("height").forGetter(Simple::height), (App)Codec.FLOAT.optionalFieldOf("offsetX", (Object)Float.valueOf(0.0f)).forGetter(Simple::offsetX), (App)Codec.FLOAT.optionalFieldOf("offsetY", (Object)Float.valueOf(0.0f)).forGetter(Simple::offsetY), (App)Codec.STRING.optionalFieldOf("animation", (Object)"").forGetter(Simple::animation), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("animationDistance", (Object)Float.valueOf(1.0f)).forGetter(Simple::animationDistance), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("animationPeriod", (Object)Float.valueOf(12.0f)).forGetter(Simple::animationPeriod)).apply((Applicative)i, Simple::new));

        @Override
        public void render(GuiGraphics graphics, float partialTicks, BoxElement element) {
            float x = (float)element.getX() + (float)element.getWidth() / 2.0f - (float)this.width / 2.0f + this.offsetX;
            float y = (float)(element.getY() + element.getHeight()) - (float)this.height / 2.0f + this.offsetY;
            float alpha = 1.0f;
            if ("breath".equals(this.animation)) {
                float breath = OverlayRenderer.ticks / 5.0f % this.animationPeriod - 2.0f;
                if (breath > 4.0f) {
                    return;
                }
                alpha = 1.0f - Math.abs(breath) / 2.0f;
                y += this.animationDistance * breath;
                if (alpha < 0.016f) {
                    return;
                }
            }
            graphics.pose().pushMatrix();
            graphics.pose().translate(x, y);
            IDisplayHelper.get().blitSprite(graphics, RenderPipelines.GUI_TEXTURED, this.sprite, 0, 0, this.width, this.height, ARGB.white((float)alpha));
            graphics.pose().popMatrix();
        }

        @Override
        public String type() {
            return "simple";
        }
    }
}

