/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.theme;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiMetadataSection;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.SneakyDetails;
import snownee.jade.api.theme.TextSetting;
import snownee.jade.api.ui.BoxElement;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.ColorPalette;
import snownee.jade.api.ui.Element;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.ui.BoxElementImpl;

public class Theme {
    public @Nullable Identifier id;
    public String styleName;
    public BoxStyle tooltipStyle;
    public BoxStyle nestedBoxStyle;
    public BoxStyle viewGroupStyle;
    public TextSetting text;
    public float changeOpacity;
    public boolean lightColorScheme;
    public @Nullable Identifier iconSlotSprite;
    public int iconSlotInflation;
    public @Nullable BoxElement iconSlotSpriteCache;
    public SneakyDetails sneakyDetails;
    public ColorPalette progressColors;
    public Map<Identifier, Identifier> spriteMapping;

    public Theme(String styleName, BoxStyle tooltipStyle, BoxStyle nestedBoxStyle, BoxStyle viewGroupStyle, TextSetting text, float changeOpacity, boolean lightColorScheme, Optional<Identifier> iconSlotSprite, int iconSlotInflation, SneakyDetails sneakyDetails, ColorPalette progressColors, Map<Identifier, Identifier> spriteMapping) {
        this.styleName = styleName;
        this.tooltipStyle = tooltipStyle;
        this.nestedBoxStyle = nestedBoxStyle;
        this.viewGroupStyle = viewGroupStyle;
        this.text = text;
        this.changeOpacity = changeOpacity;
        this.lightColorScheme = lightColorScheme;
        this.iconSlotSprite = iconSlotSprite.orElse(null);
        this.iconSlotInflation = iconSlotInflation;
        this.sneakyDetails = sneakyDetails;
        this.progressColors = progressColors;
        this.spriteMapping = spriteMapping;
    }

    public Identifier fullId() {
        return Objects.requireNonNull(this.id);
    }

    public Identifier mainId() {
        if (Objects.requireNonNull(this.id).getPath().contains("/")) {
            return this.id.withPath(this.id.getPath().substring(0, this.id.getPath().indexOf(47)));
        }
        return this.id;
    }

    public String styleId() {
        if (Objects.requireNonNull(this.id).getPath().contains("/")) {
            return this.id.getPath().substring(this.id.getPath().indexOf(47) + 1);
        }
        return "";
    }

    public Identifier mapSprite(Identifier sprite) {
        return this.spriteMapping.getOrDefault(sprite, sprite);
    }

    public @Nullable Element modifyIcon(@Nullable Element icon) {
        if (icon == null) {
            return null;
        }
        IWailaConfig.Overlay overlay = IWailaConfig.get().overlay();
        if (!overlay.shouldShowIcon() || overlay.getIconMode() == IWailaConfig.IconMode.INLINE) {
            return null;
        }
        if (this.iconSlotSprite != null) {
            if (this.iconSlotSpriteCache == null) {
                TextureAtlas guiSprites = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.GUI);
                TextureAtlasSprite textureAtlasSprite = guiSprites.getSprite(this.iconSlotSprite);
                GuiSpriteScaling scaling = textureAtlasSprite.contents().getAdditionalMetadata(GuiMetadataSection.TYPE).orElse(GuiMetadataSection.DEFAULT).scaling();
                int[] padding = new int[4];
                Arrays.fill(padding, this.iconSlotInflation);
                if (scaling instanceof GuiSpriteScaling.NineSlice) {
                    GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)scaling;
                    GuiSpriteScaling.NineSlice.Border border = nineSlice.border();
                    padding[0] = padding[0] + border.top();
                    padding[1] = padding[1] + border.right();
                    padding[2] = padding[2] + border.bottom();
                    padding[3] = padding[3] + border.left();
                }
                this.iconSlotSpriteCache = new BoxElementImpl(new Tooltip(), BoxStyle.simple(this.iconSlotSprite, padding));
            }
            Tooltip tooltip1 = this.iconSlotSpriteCache.getTooltip();
            tooltip1.clear();
            tooltip1.add(icon);
            this.iconSlotSpriteCache.updateSize();
            icon = this.iconSlotSpriteCache;
        }
        return icon.tag(JadeIds.CORE_ROOT_ICON);
    }
}

