/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.ui.IDisplayHelper;

public class EnergyView {
    public String current;
    public String max;
    public float ratio;
    public @Nullable Component overrideText;

    public EnergyView(String current, String max) {
        this.current = Objects.requireNonNull(current);
        this.max = Objects.requireNonNull(max);
    }

    public static @Nullable EnergyView read(Data data, String unit) {
        if (data.capacity <= 0L) {
            return null;
        }
        String current = IDisplayHelper.get().humanReadableNumber(data.current, unit, false);
        String max = IDisplayHelper.get().humanReadableNumber(data.capacity, unit, false);
        EnergyView energyView = new EnergyView(current, max);
        energyView.ratio = (float)data.current / (float)data.capacity;
        return energyView;
    }

    public record Data(long current, long capacity) {
        public static final StreamCodec<ByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.LONG, Data::current, (StreamCodec)ByteBufCodecs.LONG, Data::capacity, Data::new);
    }
}

