/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.NarratableComponent;
import snownee.jade.util.FluidTextHelper;

public class FluidView {
    public static final Component EMPTY_FLUID = Component.translatable((String)"jade.fluid.empty");
    public Element overlay;
    public Component current;
    public Component max;
    public float ratio;
    public @Nullable Component fluidName;
    public @Nullable Component overrideText;

    public FluidView(Element overlay, Component current, Component max) {
        this.overlay = Objects.requireNonNull(overlay);
        this.current = Objects.requireNonNull(current);
        this.max = Objects.requireNonNull(max);
    }

    public static @Nullable FluidView readDefault(Data data) {
        if (data.capacity <= 0L || data.fluids.size() > 1) {
            return null;
        }
        JadeFluidObject fluidObject = data.fluids.isEmpty() ? JadeFluidObject.empty() : data.fluids.getFirst();
        long amount = fluidObject.getAmount();
        NarratableComponent current = FluidTextHelper.getMillibuckets(amount, true);
        NarratableComponent max = FluidTextHelper.getMillibuckets(data.capacity, true);
        FluidView view = new FluidView(JadeUI.fluid(fluidObject), current, max);
        view.fluidName = fluidObject.getDisplayName();
        view.ratio = (float)((double)amount / (double)data.capacity);
        if (((Fluid)fluidObject.getType().value()).isSame(Fluids.EMPTY)) {
            view.overrideText = NarratableComponent.translatable("jade.fluid", EMPTY_FLUID, NarratableComponent.attach((Component)Component.literal((String)view.max.getString()), view.max));
        }
        return view;
    }

    public record Data(List<JadeFluidObject> fluids, long capacity) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)JadeFluidObject.STREAM_CODEC.apply(ByteBufCodecs.list()), Data::fluids, (StreamCodec)ByteBufCodecs.LONG, Data::capacity, Data::new);

        public Data(JadeFluidObject fluid, long capacity) {
            this(List.of(fluid), capacity);
        }
    }
}

