/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;

public class ViewGroup<T> {
    public List<T> views;
    public @Nullable String id;
    protected @Nullable CompoundTag extraData;

    public static <B extends ByteBuf, T> StreamCodec<B, ViewGroup<T>> codec(StreamCodec<B, T> viewCodec) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.list().apply(viewCodec), $ -> $.views, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), $ -> Optional.ofNullable($.id), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.COMPOUND_TAG), $ -> Optional.ofNullable($.extraData), ViewGroup::new);
    }

    public static <B extends ByteBuf, T> StreamCodec<B, Map.Entry<Identifier, List<ViewGroup<T>>>> listCodec(StreamCodec<B, T> viewCodec) {
        return StreamCodec.composite((StreamCodec)Identifier.STREAM_CODEC, Map.Entry::getKey, (StreamCodec)ByteBufCodecs.list().apply(ViewGroup.codec(viewCodec)), Map.Entry::getValue, Map::entry);
    }

    public ViewGroup(List<T> views) {
        this(views, Optional.empty(), Optional.empty());
    }

    public ViewGroup(List<T> views, Optional<String> id, Optional<CompoundTag> extraData) {
        this.views = views;
        this.id = id.orElse(null);
        this.extraData = extraData.orElse(null);
    }

    public CompoundTag getExtraData() {
        if (this.extraData == null) {
            this.extraData = new CompoundTag();
        }
        return this.extraData;
    }

    public void setProgress(float progress) {
        this.getExtraData().putFloat("Progress", progress);
    }
}

