/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.BitSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.layouts.AbstractLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.util.Util;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.Orientation;
import snownee.jade.gui.ResizeableLayout;

public class JadeLinearLayout
extends AbstractLayout
implements ResizeableLayout {
    private Orientation orientation;
    private Align alignItems = Align.START;
    private final List<ChildContainer> children = Lists.newArrayList();
    private final LayoutSettings defaultChildLayoutSettings = LayoutSettings.defaults();
    private int defaultHeadMargin;
    private int defaultTailMargin;
    private int minWidth;
    private int minHeight;
    private int flexGrow;
    private boolean arranged;

    public JadeLinearLayout(Orientation orientation) {
        super(0, 0, 0, 0);
        this.orientation = orientation;
    }

    public JadeLinearLayout orientation(Orientation orientation) {
        this.orientation = orientation;
        this.arranged = false;
        return this;
    }

    public JadeLinearLayout alignItems(Align align) {
        this.alignItems = align;
        this.arranged = false;
        return this;
    }

    public JadeLinearLayout spacing(int i) {
        this.defaultHeadMargin = this.defaultTailMargin = i;
        this.arranged = false;
        return this;
    }

    public JadeLinearLayout setMinDimensions(int minWidth, int minHeight) {
        return this.setMinWidth(minWidth).setMinHeight(minHeight);
    }

    public JadeLinearLayout setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        this.arranged = false;
        return this;
    }

    public JadeLinearLayout setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        this.arranged = false;
        return this;
    }

    public LayoutSettings newChildLayoutSettings() {
        return this.defaultChildLayoutSettings.copy();
    }

    public LayoutSettings defaultChildLayoutSetting() {
        return this.defaultChildLayoutSettings;
    }

    public <T extends LayoutElement> T addChild(T element) {
        return this.addChild(element, this.newChildLayoutSettings(element));
    }

    public <T extends LayoutElement> T addChild(T element, Consumer<LayoutSettings> consumer) {
        return this.addChild(element, (LayoutSettings)Util.make((Object)this.newChildLayoutSettings(element), consumer));
    }

    public <T extends LayoutElement> T addChild(T element, LayoutSettings layoutSettings) {
        return this.addChild(element, layoutSettings, null);
    }

    public <T extends LayoutElement> T addChild(T element, LayoutSettings layoutSettings, @Nullable Consumer<ChildContainer> consumer) {
        ChildContainer container = new ChildContainer(element, layoutSettings);
        container.headMargin = this.defaultHeadMargin;
        container.tailMargin = this.defaultTailMargin;
        if (consumer != null) {
            consumer.accept(container);
        }
        this.children.add(container);
        this.arranged = false;
        return element;
    }

    public void visitChildren(Consumer<LayoutElement> consumer) {
        this.children.forEach(childContainer -> consumer.accept(childContainer.child));
    }

    public void arrangeElements() {
        if (this.arranged) {
            return;
        }
        int size = this.children.size();
        if (size == 0) {
            this.height = 0;
            this.width = 0;
            this.arranged = true;
            return;
        }
        super.arrangeElements();
        int axis = 0;
        int crossAxis = 0;
        int sumGrow = 0;
        int[] margins = null;
        if (size == 1) {
            ChildContainer child = this.children.getFirst();
            axis = this.orientation.getAxisLength(child);
            crossAxis = this.orientation.getCrossAxisLength(child);
            sumGrow = child.flexGrow;
        } else {
            margins = new int[size - 1];
            ChildContainer lastChild = null;
            for (int i = 0; i < size; ++i) {
                ChildContainer child = this.children.get(i);
                if (i != 0) {
                    int margin;
                    margins[i - 1] = margin = JadeLinearLayout.calculateMargin(lastChild.tailMargin, child.headMargin);
                    axis += margin;
                }
                axis += this.orientation.getAxisLength(child);
                crossAxis = Math.max(crossAxis, this.orientation.getCrossAxisLength(child));
                sumGrow += child.flexGrow;
                lastChild = child;
            }
            this.arranged = true;
        }
        int minAxis = this.orientation == Orientation.HORIZONTAL ? this.minWidth : this.minHeight;
        int extraAxisSpace = Math.max(0, minAxis - axis);
        axis = Math.max(axis, minAxis);
        int minCrossAxis = this.orientation == Orientation.HORIZONTAL ? this.minHeight : this.minWidth;
        crossAxis = Math.max(crossAxis, minCrossAxis);
        this.resolveFlexGrow(extraAxisSpace, crossAxis, sumGrow);
        int axisPos = this.orientation.getAxisPosition(this);
        int crossAxisPos = this.orientation.getCrossAxisPosition(this);
        for (int i = 0; i < size; ++i) {
            ChildContainer child = this.children.get(i);
            int childAxisLength = this.orientation.getAxisLength(child);
            if (i != 0) {
                axisPos += margins[i - 1];
            }
            Align align = (Align)((Object)MoreObjects.firstNonNull((Object)((Object)child.alignSelf), (Object)((Object)this.alignItems)));
            align.align(this.orientation, child, axisPos, crossAxisPos, crossAxis);
            axisPos += childAxisLength;
        }
        this.width = this.orientation == Orientation.HORIZONTAL ? axis : crossAxis;
        this.height = this.orientation == Orientation.HORIZONTAL ? crossAxis : axis;
    }

    private void resolveFlexGrow(int extraAxisSpace, int crossAxis, int sumGrow) {
        if (sumGrow == 0 || extraAxisSpace <= 0) {
            return;
        }
        List<ChildContainer> children = this.children.stream().filter(it -> it.flexGrow > 0).toList();
        int size = children.size();
        if (size == 1) {
            ChildContainer child = children.getFirst();
            this.orientation.setFreeSpace(child, this.orientation.getAxisLength(child) + extraAxisSpace, crossAxis);
            return;
        }
        int reachLimitAmount = 0;
        BitSet reachLimitFlags = new BitSet(size);
        boolean changed = true;
        block0: while (changed && reachLimitAmount < size && extraAxisSpace > 0) {
            changed = false;
            int virtualSumGrow = sumGrow;
            for (int i = 0; i < size; ++i) {
                ChildContainer child = children.get(i);
                if (reachLimitFlags.get(i)) continue;
                int childAxisLength = this.orientation.getAxisLength(child);
                int grow = child.flexGrow;
                int extraChildAxis = extraAxisSpace * grow / virtualSumGrow;
                if (extraChildAxis <= 0) continue;
                int newAxisLength = childAxisLength + extraChildAxis;
                this.orientation.setFreeSpace(child, newAxisLength, crossAxis);
                int childAxisLengthNow = this.orientation.getAxisLength(child);
                changed |= childAxisLength != childAxisLengthNow;
                if (newAxisLength > childAxisLengthNow) {
                    reachLimitFlags.set(i);
                    ++reachLimitAmount;
                    if ((sumGrow -= grow) <= 0) break block0;
                }
                extraAxisSpace -= extraChildAxis;
                if ((virtualSumGrow -= grow) <= 0) continue block0;
            }
        }
    }

    private static int calculateMargin(int margin1, int margin2) {
        if (margin1 >= 0 && margin2 >= 0) {
            return Math.max(margin1, margin2);
        }
        if (margin1 < 0 && margin2 < 0) {
            return Math.min(margin1, margin2);
        }
        return margin1 + margin2;
    }

    public static JadeLinearLayout vertical() {
        return new JadeLinearLayout(Orientation.VERTICAL);
    }

    public static JadeLinearLayout horizontal() {
        return new JadeLinearLayout(Orientation.HORIZONTAL);
    }

    @Override
    public void setFreeSpace(int width, int height) {
        if (this.width >= width && this.height >= height) {
            return;
        }
        int oldMinWidth = this.minWidth;
        int oldMinHeight = this.minHeight;
        this.minWidth = Math.max(this.minWidth, width);
        this.minHeight = Math.max(this.minHeight, height);
        this.arranged = false;
        this.arrangeElements();
        this.minWidth = oldMinWidth;
        this.minHeight = oldMinHeight;
    }

    @Override
    public void setFlexGrow(int flexGrow) {
        Preconditions.checkArgument((flexGrow >= 0 ? 1 : 0) != 0, (Object)"flexGrow must be non-negative");
        this.flexGrow = flexGrow;
        this.arranged = false;
    }

    @Override
    public int getFlexGrow() {
        return this.flexGrow;
    }

    public LayoutSettings newChildLayoutSettings(LayoutElement layoutElement) {
        Element element;
        LayoutSettings settings = this.newChildLayoutSettings();
        if (layoutElement instanceof Element && (element = (Element)layoutElement).getSettings() != null) {
            settings = (LayoutSettings)element.getSettings().apply(settings);
        }
        return settings;
    }

    public int getHeight() {
        if (!this.arranged) {
            this.arrangeElements();
        }
        return super.getHeight();
    }

    public int getWidth() {
        if (!this.arranged) {
            this.arrangeElements();
        }
        return super.getWidth();
    }

    public static enum Align {
        START,
        CENTER,
        END,
        STRETCH;


        private void align(Orientation orientation, ChildContainer child, int axisPos, int crossAxisPos, int crossAxisFreeSpace) {
            int axisLength = orientation.getAxisLength(child);
            int crossAxisLength = orientation.getCrossAxisLength(child);
            switch (this.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    crossAxisPos += (crossAxisFreeSpace - crossAxisLength) / 2;
                    break;
                }
                case 2: {
                    crossAxisPos += crossAxisFreeSpace - crossAxisLength;
                    break;
                }
                case 3: {
                    orientation.setFreeSpace(child, axisLength, crossAxisFreeSpace);
                }
            }
            orientation.setPosition(child, axisPos, crossAxisPos);
        }
    }

    public static class ChildContainer
    extends AbstractLayout.AbstractChildWrapper {
        public int headMargin;
        public int tailMargin;
        public int flexGrow;
        public @Nullable Align alignSelf;

        protected ChildContainer(LayoutElement element, LayoutSettings settings) {
            super(element, settings);
        }
    }
}

