/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeKeys;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.NotUglyEditBox;
import snownee.jade.gui.config.OptionButton;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.util.JsonConfig;

public class ProfileConfigScreen
extends BaseOptionsScreen {
    private @Nullable OptionValue<Boolean> enabledEntry;

    public ProfileConfigScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"gui.jade.profile_settings"));
        this.saver = () -> {
            for (OptionsList.Entry entry : this.options().children()) {
                if (!(entry instanceof ProfileEntry)) continue;
                ProfileEntry profileEntry = (ProfileEntry)entry;
                profileEntry.save();
            }
            KeyMapping.resetMapping();
            Minecraft.getInstance().options.save();
        };
        boolean enabled = Jade.rootConfig().isEnableProfiles();
        int index = Jade.rootConfig().profileIndex;
        Runnable runnable = JadeClient.recoverKeysAction($ -> JadeKeys.openConfig().getCategory().equals((Object)$.getCategory()));
        this.canceller = () -> {
            if (enabled) {
                Jade.useProfile(index);
            } else {
                Jade.rootConfig().setEnableProfiles(false);
            }
            runnable.run();
        };
    }

    @Override
    public OptionsList createOptions(OptionsList options) {
        WailaConfig.Root root = Jade.rootConfig();
        options.title("profiles");
        this.enabledEntry = options.choices("enable_profiles", root::isEnableProfiles, value -> {
            Jade.rootConfig().setEnableProfiles(value);
            this.refresh();
        });
        for (int i = 0; i < JadeClient.profiles.length; ++i) {
            options.add(new ProfileEntry(i));
        }
        options.title("key_binds");
        for (KeyMapping keyMapping : JadeClient.profiles) {
            options.keybind(keyMapping);
        }
        return options;
    }

    @Override
    protected void init() {
        super.init();
        this.refresh();
    }

    public void refresh() {
        boolean enabled = Jade.rootConfig().isEnableProfiles();
        for (OptionsList.Entry entry : this.options().children()) {
            if (entry == this.enabledEntry) continue;
            entry.setDisabled(!enabled);
            if (!(entry instanceof ProfileEntry)) continue;
            ProfileEntry profileEntry = (ProfileEntry)entry;
            profileEntry.refresh();
        }
    }

    public static class ProfileEntry
    extends OptionButton {
        public static final Component USE = Component.translatable((String)"gui.jade.profile.use");
        public static final Component SAVE = Component.translatable((String)"selectWorld.edit.save");
        private final int index;
        private final Component normalTitle;
        private final NotUglyEditBox editBox;
        private final @Nullable String originalName;

        public ProfileEntry(int index) {
            super((Component)Component.translatable((String)("config.jade.profile." + index)), (Button)null);
            this.index = index;
            this.normalTitle = this.title;
            this.editBox = new NotUglyEditBox(Minecraft.getInstance().font, 0, 0, 120, 20, this.title);
            this.editBox.fixedTextX = 4;
            this.editBox.fixedTextY = 6;
            this.editBox.fixedInnerWidth = this.editBox.getWidth() - 4 - 12;
            this.editBox.backgroundMode = NotUglyEditBox.BackgroundMode.HOVERING;
            this.editBox.setMaxLength(100);
            this.editBox.setHint(this.normalTitle);
            String name = Jade.configs().get(index).get().getName();
            if (name.startsWith("@")) {
                this.editBox.setValue(I18n.get((String)name.substring(1), (Object[])new Object[0]));
                this.originalName = this.editBox.getValue();
            } else {
                this.editBox.setValue(name);
                this.originalName = null;
            }
            this.addWidget(new OptionsList.EntryWidget((AbstractWidget)this.editBox, -4, -this.editBox.getHeight() / 2, false));
            this.addWidget((AbstractWidget)Button.builder((Component)USE, $ -> {
                Jade.useProfile(index);
                Screen patt0$temp = Minecraft.getInstance().screen;
                if (patt0$temp instanceof ProfileConfigScreen) {
                    ProfileConfigScreen screen = (ProfileConfigScreen)patt0$temp;
                    screen.refresh();
                }
            }).size(48, 20).build(), 0);
            this.addWidget((AbstractWidget)Button.builder((Component)SAVE, $ -> {
                if (JadeUI.hasControlDown()) {
                    Jade.saveProfile(index);
                    return;
                }
                Minecraft mc = Minecraft.getInstance();
                Screen screen = mc.screen;
                mc.setScreen((Screen)new ConfirmScreen(bl -> {
                    if (bl) {
                        Jade.saveProfile(index);
                    }
                    Minecraft.getInstance().setScreen(screen);
                }, (Component)Component.translatable((String)"gui.jade.save_profile.title"), (Component)Component.translatable((String)"gui.jade.save_profile.message", (Object[])new Object[]{this.normalTitle}), (Component)Component.translatable((String)"gui.continue"), (Component)Component.translatable((String)"gui.cancel")));
            }).size(48, 20).build(), 52);
            this.addMessage(SAVE.getString());
        }

        public void refresh() {
            WailaConfig.Root root = Jade.rootConfig();
            boolean current = this.index == root.profileIndex;
            this.title = current ? this.normalTitle.copy().append((Component)Component.translatable((String)"gui.jade.profile.active")) : this.normalTitle;
            boolean enabled = root.isEnableProfiles();
            for (AbstractWidget abstractWidget : this.children()) {
                if (abstractWidget == this.editBox) {
                    this.editBox.setTextColor(enabled && current ? -171 : -2039584);
                    this.editBox.setEditable(enabled);
                    continue;
                }
                if (!enabled) continue;
                abstractWidget.active = !current;
            }
        }

        public void save() {
            JsonConfig<? extends WailaConfig> config = Jade.configs().get(this.index);
            if (this.originalName == null || !this.originalName.equals(this.editBox.getValue())) {
                config.get().setName(this.editBox.getValue());
            }
            config.save();
        }

        @Override
        protected boolean shouldRenderTitle() {
            return false;
        }
    }
}

