/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.io.File;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import org.jspecify.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeKeys;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.gui.MultilineTooltip;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.config.OptionButton;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.CycleOptionValue;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.impl.theme.ThemeHelper;
import snownee.jade.util.CommonProxy;

public class WailaConfigScreen
extends PreviewOptionsScreen {
    private @Nullable CycleOptionValue<Identifier> styleEntry;
    private @Nullable OptionValue<Float> opacityEntry;

    public WailaConfigScreen(@Nullable Screen parent) {
        super(parent, (Component)Component.translatable((String)"gui.jade.jade_settings"));
        this.saver = () -> {
            IWailaConfig.get().save();
            JadeClient.refreshKeyState();
            KeyMapping.resetMapping();
            Minecraft.getInstance().options.save();
        };
        Runnable runnable = JadeClient.recoverKeysAction($ -> JadeKeys.openConfig().getCategory().equals((Object)$.getCategory()));
        this.canceller = () -> {
            IWailaConfig.get().invalidate();
            runnable.run();
        };
    }

    public static OptionsList.Entry editIgnoreList(OptionsList.Entry entry, String fileName, Runnable defaultFactory) {
        Objects.requireNonNull(entry.getFirstWidget()).setWidth(79);
        MutableComponent tooltip = Component.translatable((String)"config.jade.edit_ignore_list");
        entry.addWidget((AbstractWidget)Button.builder((Component)Component.literal((String)"\u2630"), b -> {
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                JadeClient.pleaseWait();
            }).start();
            File file = new File(CommonProxy.getConfigDirectory(), "jade/%s.json".formatted(fileName));
            if (!file.exists()) {
                defaultFactory.run();
            }
            Util.getPlatform().openFile(file);
        }).size(20, 20).tooltip(Tooltip.create((Component)tooltip)).createNarration($ -> tooltip).build(), 80);
        return entry;
    }

    @Override
    public OptionsList createOptions(OptionsList options) {
        IWailaConfig.General general = IWailaConfig.get().general();
        options.title("general");
        if (CommonProxy.isDevEnv()) {
            options.choices("debug_mode", general::isDebug, general::setDebug);
        }
        options.choices("display_tooltip", general::shouldDisplayTooltip, general::setDisplayTooltip);
        OptionValue<Boolean> entry = options.choices("display_entities", general::getDisplayEntities, general::setDisplayEntities);
        WailaConfigScreen.editIgnoreList(entry, "hide-entities", () -> WailaClientRegistration.instance().reloadIgnoreLists());
        options.choices("display_bosses", general::getDisplayBosses, general::setDisplayBosses).parent(entry);
        entry = options.choices("display_blocks", general::getDisplayBlocks, general::setDisplayBlocks);
        WailaConfigScreen.editIgnoreList(entry, "hide-blocks", () -> WailaClientRegistration.instance().reloadIgnoreLists());
        options.choices("display_fluids", general::getDisplayFluids, general::setDisplayFluids).parent(entry);
        options.choices("display_mode", general::getDisplayMode, general::setDisplayMode);
        OptionValue<Boolean> value = options.choices("item_mod_name", general::showItemModNameTooltip, general::setItemModNameTooltip);
        if (!WailaConfig.General.itemModNameTooltipDisabledByModsNames.isEmpty()) {
            value.setDisabled(true);
            value.appendDescription((Component)Component.translatable((String)"gui.jade.disabled_by_mods"));
            WailaConfig.General.itemModNameTooltipDisabledByModsNames.stream().map(Component::literal).forEach(value::appendDescription);
            if (value.getFirstWidget() != null) {
                value.getFirstWidget().setTooltip(MultilineTooltip.create(value.getDescription()));
            }
        }
        options.choices("hide_from_guis", general::shouldHideFromGUIs, general::setHideFromGUIs);
        options.choices("boss_bar_overlap", general::getBossBarOverlapMode, general::setBossBarOverlapMode);
        options.slider("reach_distance", general::getExtendedReach, general::setExtendedReach, 0.0f, 20.0f, f -> (float)Mth.floor((float)(f * 2.0f)) / 2.0f);
        options.choices("perspective_mode", general::getPerspectiveMode, general::setPerspectiveMode);
        final IWailaConfig.Overlay overlay = IWailaConfig.get().overlay();
        options.title("overlay");
        MutableComponent adjust = Component.translatable((String)OptionsList.Entry.makeKey("overlay_pos.adjust"));
        options.add(new OptionButton((Component)Component.translatable((String)OptionsList.Entry.makeKey("overlay_pos")), Button.builder((Component)adjust, w -> this.startAdjustingPosition()).size(100, 20)));
        CycleButton.ValueListSupplier<Identifier> valuesSupplier = new CycleButton.ValueListSupplier<Identifier>(this){

            public List<Identifier> getSelectedList() {
                return this.getDefaultList();
            }

            public List<Identifier> getDefaultList() {
                Identifier mainId = overlay.getTheme().mainId();
                return IThemeHelper.get().getThemes().stream().filter($ -> $.mainId().equals((Object)mainId)).map(Theme::fullId).toList();
            }
        };
        CycleOptionValue<Identifier> themeEntry = options.add(new CycleOptionValue<Identifier>("overlay_theme", CycleButton.builder(id -> Component.translatable((String)Util.makeDescriptionId((String)"jade.theme", (Identifier)id)), (Object)overlay.getTheme().mainId()).withValues(IThemeHelper.get().getThemes().stream().filter($ -> $.styleId().isEmpty()).map(Theme::fullId).toList()), () -> overlay.getTheme().mainId(), id -> {
            if (Objects.equals(id, overlay.getTheme().mainId())) {
                return;
            }
            if (!ThemeHelper.INSTANCE.hasTheme((Identifier)id)) {
                return;
            }
            overlay.applyTheme((Identifier)id);
            Theme theme = overlay.getTheme();
            if (theme.changeOpacity != 0.0f) {
                Objects.requireNonNull(this.opacityEntry).setValue(Float.valueOf(theme.changeOpacity));
            }
            Objects.requireNonNull(this.styleEntry).updateValue();
        }));
        this.styleEntry = options.add(new CycleOptionValue<Identifier>(this, "theme_style", CycleButton.builder(id -> Component.translatable((String)ThemeHelper.INSTANCE.getTheme((Identifier)id).styleName), (Object)overlay.getTheme().fullId()).withValues((CycleButton.ValueListSupplier)valuesSupplier), () -> overlay.getTheme().id, overlay::applyTheme, (CycleButton.ValueListSupplier)valuesSupplier){
            final /* synthetic */ CycleButton.ValueListSupplier val$valuesSupplier;
            {
                this.val$valuesSupplier = valueListSupplier;
                super(optionName, cycleBtn, getter, setter);
            }

            @Override
            public void updateValue() {
                super.updateValue();
                if (this.val$valuesSupplier.getDefaultList().size() > 1) {
                    this.button.active = true;
                } else {
                    this.button.active = false;
                    this.button.setMessage((Component)Component.translatable((String)"jade.unavailable"));
                }
            }
        });
        this.styleEntry.parent(themeEntry);
        this.styleEntry.updateValue();
        this.opacityEntry = options.slider("overlay_alpha", overlay::getAlpha, overlay::setAlpha);
        options.forcePreview.add(options.slider("overlay_scale", overlay::getOverlayScale, overlay::setOverlayScale, 0.2f, 2.0f, FloatUnaryOperator.identity()));
        options.choices("display_item", overlay::getIconMode, overlay::setIconMode);
        options.choices("animation", overlay::getAnimation, overlay::setAnimation);
        options.title("key_binds");
        options.keybind(JadeKeys.openConfig());
        options.keybind(JadeKeys.showOverlay());
        options.keybind(JadeKeys.toggleLiquid());
        if (JadeKeys.hasRecipeViewerKeys()) {
            options.keybind(JadeKeys.showRecipes());
            options.keybind(JadeKeys.showUses());
        }
        options.keybind(JadeKeys.narrate());
        options.keybind(JadeKeys.showDetails());
        IWailaConfig.Accessibility accessibility = IWailaConfig.get().accessibility();
        options.title("accessibility");
        options.choices("accessibility_plugin", accessibility::getEnableAccessibilityPlugin, accessibility::setEnableAccessibilityPlugin);
        options.choices("tts_mode", accessibility::getTTSMode, accessibility::setTTSMode);
        options.choices("narrate_keys", accessibility::getNarrateKeys, accessibility::setNarrateKeys);
        options.slider("text_background_opacity", accessibility::getTextBackgroundOpacity, accessibility::setTextBackgroundOpacity);
        options.choices("flip_main_hand", accessibility::getFlipMainHand, accessibility::setFlipMainHand);
        options.title("danger_zone").withStyle(ChatFormatting.RED);
        options.add(new OptionButton("reload_plugins", Button.builder((Component)OptionsList.Entry.makeTitle("reload_plugins.button"), w -> {
            w.active = false;
            Jade.loadPlugins();
            w.active = true;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.PLAYER_LEVELUP, (float)1.0f));
        }).size(100, 20).build()));
        MutableComponent reset = Component.translatable((String)"controls.reset").withStyle(ChatFormatting.RED);
        MutableComponent title = Component.translatable((String)OptionsList.Entry.makeKey("reset_settings")).withStyle(ChatFormatting.RED);
        options.add(new OptionButton((Component)title, Button.builder((Component)reset, arg_0 -> this.lambda$createOptions$18((Component)title, (Component)reset, arg_0)).size(100, 20)));
        return options;
    }

    private /* synthetic */ void lambda$createOptions$18(Component title, Component reset, Button w) {
        this.minecraft.setScreen((Screen)new ConfirmScreen(bl -> {
            if (bl) {
                for (KeyMapping keyMapping : this.minecraft.options.keyMappings) {
                    if (!JadeKeys.openConfig().getCategory().equals((Object)keyMapping.getCategory())) continue;
                    keyMapping.setKey(keyMapping.getDefaultKey());
                }
                this.minecraft.options.save();
                try {
                    Jade.resetConfig();
                    this.rebuildWidgets();
                }
                catch (Throwable e) {
                    Jade.LOGGER.error("", e);
                }
            }
            this.minecraft.setScreen((Screen)this);
            this.options().setScrollAmount(this.options().maxScrollAmount());
        }, title, (Component)Component.translatable((String)OptionsList.Entry.makeKey("reset_settings.confirm")), reset, (Component)Component.translatable((String)"gui.cancel")));
    }
}

