/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.Nullable;
import snownee.jade.gui.config.OptionButton;
import snownee.jade.gui.config.OptionsList;

public class KeybindOptionButton
extends OptionButton {
    private final KeyMapping keybind;

    public KeybindOptionButton(OptionsList owner, KeyMapping keybind) {
        super((Component)Component.translatable((String)keybind.getName()), (Button)null);
        this.keybind = keybind;
        Button button = Button.builder((Component)keybind.getTranslatedKeyMessage(), b -> {
            owner.selectedKey = this.keybind;
            owner.resetMappingAndUpdateButtons();
        }).size(100, 20).createNarration(supplier -> {
            if (this.keybind.isUnbound()) {
                return Component.translatable((String)"narrator.controls.unbound", (Object[])new Object[]{this.title});
            }
            return Component.translatable((String)"narrator.controls.bound", (Object[])new Object[]{this.title, supplier.get()});
        }).build();
        this.addWidget((AbstractWidget)button, 0);
    }

    public void refresh(@Nullable KeyMapping selectedKey) {
        AbstractWidget button = Objects.requireNonNull(this.getFirstWidget());
        if (selectedKey == this.keybind) {
            button.setMessage((Component)Component.literal((String)"> ").append((Component)button.getMessage().copy().withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE})).append(" <").withStyle(ChatFormatting.YELLOW));
        } else {
            button.setMessage(this.keybind.getTranslatedKeyMessage());
        }
    }
}

