/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import org.jspecify.annotations.Nullable;

public class NotUglyEditBox
extends EditBox {
    public @Nullable Integer fixedTextX;
    public @Nullable Integer fixedTextY;
    public @Nullable Integer fixedInnerWidth;
    public WidgetSprites background = EditBox.SPRITES;
    public BackgroundMode backgroundMode = BackgroundMode.VISIBLE;
    public boolean alwaysRenderCross;
    private boolean isMouseOverCross;

    public NotUglyEditBox(Font font, int i, int j, Component component) {
        super(font, i, j, component);
        this.setBordered(false);
    }

    public NotUglyEditBox(Font font, int i, int j, int k, int l, Component component) {
        super(font, i, j, k, l, component);
        this.setBordered(false);
    }

    public NotUglyEditBox(Font font, int i, int j, int k, int l, @Nullable EditBox editBox, Component component) {
        super(font, i, j, k, l, editBox, component);
        this.setBordered(false);
    }

    public void updateTextPosition() {
        super.updateTextPosition();
        if (this.fixedTextX != null) {
            this.textX = this.getX() + this.fixedTextX;
        }
        if (this.fixedTextY != null) {
            this.textY = this.getY() + this.fixedTextY;
        }
    }

    public int getInnerWidth() {
        return this.fixedInnerWidth != null ? this.fixedInnerWidth.intValue() : super.getInnerWidth();
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.isVisible()) {
            float bgAlpha;
            if (this.backgroundMode == BackgroundMode.HOVERING) {
                bgAlpha = this.isFocused() ? 1.0f : (this.isActive() && this.isHovered() ? 0.25f : 0.0f);
            } else {
                float f2 = bgAlpha = this.backgroundMode == BackgroundMode.VISIBLE ? 1.0f : 0.0f;
            }
            if (bgAlpha > 0.0f) {
                Identifier Identifier2 = this.background.get(this.isActive(), this.isFocused());
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Identifier2, this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)bgAlpha));
                if (this.isEditable() && !this.getValue().isEmpty() && (this.alwaysRenderCross || this.isHovered)) {
                    this.isMouseOverCross = this.isHovered && i > this.getRight() - 12;
                    int c = this.isMouseOverCross ? this.textColor : this.textColorUneditable;
                    guiGraphics.drawString(this.font, "\u00d7", this.getX() + this.width - 10, this.textY + 1, c);
                }
            }
        }
        super.renderWidget(guiGraphics, i, j, f);
        if (this.isMouseOverCross) {
            guiGraphics.requestCursor(CursorTypes.POINTING_HAND);
        }
    }

    public void onClick(MouseButtonEvent mouseButtonEvent, boolean bl) {
        if (this.isMouseOverCross) {
            this.setValue("");
            return;
        }
        super.onClick(mouseButtonEvent, bl);
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.isMouseOverCross) {
            narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.jade.clear_content.usage"));
        }
    }

    public static enum BackgroundMode {
        VISIBLE,
        INVISIBLE,
        HOVERING;

    }
}

