/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.InputType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.util.Util;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.WailaConfigScreen;
import snownee.jade.gui.config.KeybindOptionButton;
import snownee.jade.gui.config.OptionsNav;
import snownee.jade.gui.config.value.CycleOptionValue;
import snownee.jade.gui.config.value.InputOptionValue;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.gui.config.value.SliderOptionValue;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.SmoothChasingValue;

public class OptionsList
extends ContainerObjectSelectionList<Entry> {
    public static final Component OPTION_ON = CommonComponents.OPTION_ON.copy().withColor(-4589878);
    public static final Component OPTION_OFF = CommonComponents.OPTION_OFF.copy().withColor(-30080);
    public final Set<Entry> forcePreview = Sets.newIdentityHashSet();
    protected final List<Entry> entries = Lists.newArrayList();
    private final @Nullable Runnable diskWriter;
    public @Nullable Title currentTitle;
    public @Nullable OptionValue<?> invalidEntry;
    public @Nullable KeyMapping selectedKey;
    private final BaseOptionsScreen owner;
    private final SmoothChasingValue smoothScroll;
    private @Nullable Entry defaultParent;

    public OptionsList(BaseOptionsScreen owner, Minecraft client, int x, int y, int width, int height, int entryHeight, @Nullable Runnable diskWriter) {
        super(client, width, height, y, entryHeight);
        this.setX(x);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.smoothScroll = new SmoothChasingValue().withSpeed(0.6f);
    }

    public OptionsList(BaseOptionsScreen owner, Minecraft client, int x, int y, int width, int height, int entryHeight) {
        this(owner, client, x, y, width, height, entryHeight, null);
    }

    private static void walkChildren(Entry entry, Consumer<Entry> consumer) {
        consumer.accept(entry);
        for (Entry child : entry.children) {
            OptionsList.walkChildren(child, consumer);
        }
    }

    public int getRowWidth() {
        return Math.min(this.width, 300);
    }

    protected int scrollBarX() {
        return this.owner.width - 6;
    }

    public void setScrollAmount(double scroll) {
        this.smoothScroll.target(Mth.clamp((float)((float)scroll), (float)0.0f, (float)this.maxScrollAmount()));
    }

    public void forceSetScrollAmount(double scroll) {
        this.smoothScroll.start((float)scroll);
        super.setScrollAmount(scroll);
    }

    protected double scrollRate() {
        return (double)this.defaultEntryHeight * (!ClientProxy.hasFastScroll && JadeUI.hasControlDown() ? 4.5 : 1.5);
    }

    public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double d, double e) {
        this.smoothScroll.value = this.smoothScroll.getTarget();
        super.setScrollAmount((double)this.smoothScroll.value);
        return super.mouseDragged(mouseButtonEvent, d, e);
    }

    public boolean isFocused() {
        return this.owner.getFocused() == this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public @Nullable ComponentPath nextFocusPath(FocusNavigationEvent event) {
        Title title;
        OptionsNav.Entry navEntry = (OptionsNav.Entry)this.owner.optionsNav().getFocused();
        if (navEntry == null || !(event instanceof FocusNavigationEvent.ArrowNavigation)) return super.nextFocusPath(event);
        FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
        try {
            ScreenDirection screenDirection;
            ScreenDirection direction = screenDirection = arrowNavigation.direction();
            if (direction != ScreenDirection.RIGHT) return super.nextFocusPath(event);
            title = navEntry.getTitle();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        this.setFocused((GuiEventListener)title);
        ComponentPath path = super.nextFocusPath((FocusNavigationEvent)new FocusNavigationEvent.ArrowNavigation(ScreenDirection.DOWN));
        this.setFocused(null);
        return path;
    }

    public void scrollToEntry(Entry entry) {
        super.scrollToEntry((AbstractSelectionList.Entry)entry);
    }

    protected boolean entriesCanBeSelected() {
        if (PreviewOptionsScreen.isAdjustingPosition()) {
            return false;
        }
        return super.entriesCanBeSelected();
    }

    protected void renderListSeparators(GuiGraphics guiGraphics) {
        Identifier Identifier2 = this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Identifier2, 0, this.getBottom(), 0.0f, 0.0f, this.owner.width, 2, 32, 2);
    }

    protected void renderSelection(GuiGraphics guiGraphics, Entry entry, int i) {
        guiGraphics.fill(this.getX(), i - 2, this.getRight(), i + entry.getContentHeight() + 2, 0x33FFFFFF);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        float deltaTicks = Minecraft.getInstance().getDeltaTracker().getRealtimeDeltaTicks();
        this.smoothScroll.tick(deltaTicks);
        super.setScrollAmount((double)Math.round(this.smoothScroll.value));
        this.hovered = null;
        if (!PreviewOptionsScreen.isAdjustingPosition()) {
            InputType lastInputType = this.minecraft.getLastInputType();
            mouseY = Math.min(mouseY, this.getRowRight());
            if (lastInputType.isMouse() && this.isMouseOver(mouseX, mouseY)) {
                this.hovered = this.getEntryAtPosition(mouseX, mouseY);
            } else if (lastInputType.isKeyboard() && this.getFocused() != null) {
                this.hovered = this.getFocused();
            }
            AbstractSelectionList.Entry entry = this.hovered;
            if (entry instanceof Title) {
                Title title = (Title)entry;
                this.setSelected((Entry)null);
                this.currentTitle = title;
            } else {
                Entry entry2;
                this.setSelected((Entry)this.hovered);
                if (this.hovered != null && (entry2 = ((Entry)this.hovered).root()) instanceof Title) {
                    Title title;
                    this.currentTitle = title = (Title)entry2;
                }
            }
        }
        this.enableScissor(guiGraphics);
        this.renderListItems(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.disableScissor();
        this.renderListSeparators(guiGraphics);
        this.renderScrollbar(guiGraphics, mouseX, mouseY);
    }

    public void save() {
        this.children().stream().filter(e -> e instanceof OptionValue).map(e -> (OptionValue)((Object)e)).forEach(OptionValue::save);
        if (this.diskWriter != null) {
            this.diskWriter.run();
        }
    }

    public <T extends Entry> T add(T entry) {
        this.entries.add(entry);
        if (entry instanceof Title) {
            this.setDefaultParent(entry);
        } else if (this.defaultParent != null) {
            entry.parent(this.defaultParent);
        }
        return entry;
    }

    public @Nullable Entry getEntryAt(double x, double y) {
        return (Entry)this.getEntryAtPosition(x, y);
    }

    public int getRowTop(int i) {
        return super.getRowTop(i);
    }

    public int getRowBottom(int i) {
        return super.getRowBottom(i);
    }

    public void setDefaultParent(Entry defaultParent) {
        this.defaultParent = defaultParent;
    }

    public MutableComponent title(String string) {
        return this.add(new Title(string)).getTitle();
    }

    public OptionValue<Float> slider(String optionName, Supplier<Float> getter, Consumer<Float> setter) {
        return this.slider(optionName, getter, setter, 0.0f, 1.0f, FloatUnaryOperator.identity());
    }

    public OptionValue<Float> slider(String optionName, Supplier<Float> getter, Consumer<Float> setter, float min, float max, FloatUnaryOperator aligner) {
        return this.add(new SliderOptionValue(optionName, getter, setter, min, max, aligner));
    }

    public <T> OptionValue<T> input(String optionName, Supplier<T> getter, Consumer<T> setter, Predicate<String> validator) {
        return this.add(new InputOptionValue<T>(this::updateSaveState, optionName, getter, setter, validator));
    }

    public <T> OptionValue<T> input(String optionName, Supplier<T> getter, Consumer<T> setter) {
        return this.input(optionName, getter, setter, (Predicate<String>)Predicates.alwaysTrue());
    }

    public OptionValue<Boolean> choices(String optionName, Supplier<Boolean> getter, BooleanConsumer setter) {
        return this.choices(optionName, getter, setter, null);
    }

    public OptionValue<Boolean> choices(String optionName, Supplier<Boolean> getter, BooleanConsumer setter, @Nullable Consumer<// Could not load outer class - annotation placement on inner may be incorrect
    CycleButton.Builder<Boolean>> builderConsumer) {
        CycleButton.Builder builder = CycleButton.booleanBuilder((Component)OPTION_ON, (Component)OPTION_OFF, (boolean)getter.get());
        if (builderConsumer != null) {
            builderConsumer.accept((CycleButton.Builder<Boolean>)builder);
        }
        return this.add(new CycleOptionValue<Boolean>(optionName, (CycleButton.Builder<Boolean>)builder, getter, (Consumer<Boolean>)setter));
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, Supplier<T> getter, Consumer<T> setter) {
        return this.choices(optionName, getter, setter, null);
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, Supplier<T> getter, Consumer<T> setter, @Nullable Consumer<// Could not load outer class - annotation placement on inner may be incorrect
    CycleButton.Builder<T>> builderConsumer) {
        List<Enum> values = Arrays.asList((Enum[])((Enum)getter.get()).getDeclaringClass().getEnumConstants());
        CycleButton.Builder builder = CycleButton.builder(v -> {
            String name;
            return switch (name = v.name().toLowerCase(Locale.ENGLISH)) {
                case "on" -> OPTION_ON;
                case "off" -> OPTION_OFF;
                default -> Entry.makeTitle(optionName + "_" + name);
            };
        }, (Object)((Enum)getter.get())).withValues(values);
        builder.withTooltip(v -> {
            String key = Entry.makeKey(optionName + "_" + v.name().toLowerCase(Locale.ENGLISH) + "_desc");
            if (!I18n.exists((String)key)) {
                return null;
            }
            return Tooltip.create((Component)WailaConfigScreen.processBuiltInVariables((Component)Component.translatable((String)key)));
        });
        if (builderConsumer != null) {
            builderConsumer.accept(builder);
        }
        return this.add(new CycleOptionValue<T>(optionName, builder, getter, setter));
    }

    public <T> OptionValue<T> choices(String optionName, Supplier<T> getter, List<T> values, Consumer<T> setter, Function<T, Component> nameProvider) {
        return this.add(new CycleOptionValue<T>(optionName, CycleButton.builder(nameProvider, getter.get()).withValues(values), getter, setter));
    }

    public void keybind(KeyMapping keybind) {
        this.add(new KeybindOptionButton(this, keybind));
    }

    public void removed() {
        this.forcePreview.clear();
        for (Entry entry : this.entries) {
            entry.parent = null;
            if (entry.children.isEmpty()) continue;
            entry.children.clear();
        }
        this.clearEntries();
    }

    public void updateSearch(String search) {
        this.clearEntries();
        if (search.isBlank()) {
            this.entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
            return;
        }
        LinkedHashSet matches = Sets.newLinkedHashSet();
        String[] keywords = search.toLowerCase(Locale.ENGLISH).split("\\s+");
        for (Entry entry : this.entries) {
            int bingo = 0;
            List<String> messages = entry.getMessages();
            block1: for (String keyword : keywords) {
                for (String message : messages) {
                    if (!message.contains(keyword)) continue;
                    ++bingo;
                    continue block1;
                }
            }
            if (bingo != keywords.length) continue;
            OptionsList.walkChildren(entry, matches::add);
            while (entry.parent() != null) {
                entry = Objects.requireNonNull(entry.parent());
                matches.add(entry);
            }
        }
        for (Entry entry : this.entries) {
            if (!matches.contains((Object)entry)) continue;
            this.addEntry((AbstractSelectionList.Entry)entry);
        }
        if (matches.isEmpty()) {
            this.addEntry((AbstractSelectionList.Entry)new Title(Component.translatable((String)"gui.jade.no_results").withStyle(ChatFormatting.GRAY)));
        }
    }

    public void updateSaveState() {
        this.invalidEntry = null;
        for (Entry entry : this.entries) {
            OptionValue value;
            if (!(entry instanceof OptionValue) || (value = (OptionValue)entry).isValidValue()) continue;
            this.invalidEntry = value;
            break;
        }
        if (this.invalidEntry == null) {
            Objects.requireNonNull(this.owner.saveButton).setTooltip(null);
        } else {
            Objects.requireNonNull(this.owner.saveButton).setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.jade.invalid_value_cant_save")));
        }
    }

    public void updateOptionValue(@Nullable Identifier key) {
        for (Entry entry : this.entries) {
            if (!(entry instanceof OptionValue)) continue;
            OptionValue value = (OptionValue)entry;
            if (key != null && !key.equals((Object)value.getId())) continue;
            value.updateValue();
        }
    }

    public void showOnTop(Entry entry) {
        this.setScrollAmount(this.defaultEntryHeight * this.children().indexOf((Object)entry) + 1);
        if (entry instanceof Title) {
            Title title;
            this.currentTitle = title = (Title)entry;
        }
    }

    public void resetMappingAndUpdateButtons() {
        for (Entry entry : this.entries) {
            if (!(entry instanceof KeybindOptionButton)) continue;
            KeybindOptionButton button = (KeybindOptionButton)entry;
            button.refresh(this.selectedKey);
        }
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.selectedKey != null) {
            if (keyEvent.isEscape()) {
                this.selectedKey.setKey(InputConstants.UNKNOWN);
            } else {
                this.selectedKey.setKey(InputConstants.getKey((KeyEvent)keyEvent));
            }
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        if (this.selectedKey != null) {
            this.selectedKey.setKey(InputConstants.Type.MOUSE.getOrCreate(event.button()));
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
            return false;
        }
        return super.mouseClicked(event, bl);
    }

    public void setSelected(@Nullable Entry entry) {
        this.selected = entry;
        if (entry != null && this.minecraft.getLastInputType().isKeyboard()) {
            this.scrollToEntry(entry);
        }
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected final Minecraft client;
        protected final List<String> messages = Lists.newArrayList();
        private final List<AbstractWidget> rawWidgets = Lists.newArrayList();
        protected final List<EntryWidget> widgets = Lists.newArrayList();
        protected List<Component> description = List.of();
        private @Nullable Entry parent;
        private List<Entry> children = List.of();

        public Entry() {
            this.client = Minecraft.getInstance();
        }

        public static MutableComponent makeTitle(String key) {
            return Component.translatable((String)Entry.makeKey(key));
        }

        public static String makeKey(String key) {
            return Util.makeDescriptionId((String)"config", (Identifier)Identifier.fromNamespaceAndPath((String)"jade", (String)key));
        }

        public @Nullable AbstractWidget getFirstWidget() {
            return this.rawWidgets.isEmpty() ? null : this.rawWidgets.getFirst();
        }

        public void addWidget(AbstractWidget widget, int offsetX) {
            this.addWidget(new EntryWidget(widget, offsetX, -widget.getHeight() / 2, true));
        }

        public void addWidget(EntryWidget widget) {
            this.widgets.add(widget);
            this.rawWidgets.add(widget.widget());
        }

        public List<? extends AbstractWidget> children() {
            return this.rawWidgets;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children();
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            for (EntryWidget widget : this.widgets) {
                AbstractWidget rawWidget = widget.widget();
                int x = widget.floatRight() ? this.getContentWidth() - 110 + widget.offsetX() : 10 + widget.offsetX();
                rawWidget.setX(this.getContentX() + x);
                rawWidget.setY(this.getContentY() + this.getContentHeight() / 2 + widget.offsetY());
                rawWidget.render(guiGraphics, mouseX, mouseY, deltaTime);
            }
        }

        public void setDisabled(boolean disabled) {
            for (AbstractWidget widget : this.rawWidgets) {
                boolean bl = widget.active = !disabled;
                if (!(widget instanceof EditBox)) continue;
                EditBox editBox = (EditBox)widget;
                editBox.setEditable(!disabled);
            }
        }

        public List<Component> getDescription() {
            return this.description;
        }

        public List<Component> getDescriptionOnShift() {
            return List.of();
        }

        public int getTextX() {
            return 0;
        }

        public int getTextWidth() {
            return 0;
        }

        public Entry parent(Entry parent) {
            this.parent = parent;
            if (parent.children.isEmpty()) {
                parent.children = Lists.newArrayList();
            }
            parent.children.add(this);
            return this;
        }

        public @Nullable Entry parent() {
            return this.parent;
        }

        public Entry root() {
            Entry entry = this;
            while (entry.parent() != null) {
                entry = Objects.requireNonNull(entry.parent());
            }
            return entry;
        }

        public final List<String> getMessages() {
            return this.messages;
        }

        public void addMessage(String message) {
            this.messages.add(StringUtil.stripColor((String)message).toLowerCase(Locale.ENGLISH));
        }

        public void addMessageKey(String key) {
            if (I18n.exists((String)(key = Entry.makeKey(key + "_extra_msg")))) {
                this.addMessage(I18n.get((String)key, (Object[])new Object[0]));
            }
        }
    }

    public static class Title
    extends Entry {
        public Component narration;
        private final MutableComponent title;

        public Title(String key) {
            this.title = Title.makeTitle(key);
            this.addMessageKey(key);
            this.addMessage(this.title.getString());
            key = Title.makeKey(key + "_desc");
            if (I18n.exists((String)key)) {
                this.description = List.of(Component.translatable((String)key));
                this.addMessage(((Component)this.description.getFirst()).getString());
            }
            this.narration = Component.translatable((String)"narration.jade.category", (Object[])new Object[]{this.title});
        }

        public Title(MutableComponent title) {
            this.title = title;
            this.narration = title;
        }

        public MutableComponent getTitle() {
            return this.title;
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            Font font = this.client.font;
            int n = this.getTextX();
            int n2 = this.getContentY() + this.getContentHeight();
            Objects.requireNonNull(this.client.font);
            guiGraphics.drawString(font, (Component)this.title, n, n2 - 9, -1);
        }

        @Override
        public int getTextX() {
            return this.getContentXMiddle() - this.getTextWidth() / 2;
        }

        @Override
        public int getTextWidth() {
            return this.client.font.width((FormattedText)this.title);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput narrationElementOutput) {
                    narrationElementOutput.add(NarratedElementType.TITLE, narration);
                }
            });
        }
    }

    public record EntryWidget(AbstractWidget widget, int offsetX, int offsetY, boolean floatRight) {
    }
}

