/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.network.ServerPayloadContext;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class EntityAccessorImpl
extends AccessorImpl<EntityHitResult>
implements EntityAccessor {
    private final Supplier<Entity> entity;

    public EntityAccessorImpl(Builder builder) {
        super(Objects.requireNonNull(builder.level), Objects.requireNonNull(builder.player), builder.serverData, Objects.requireNonNull(builder.hit), builder.connected, builder.showDetails);
        this.entity = Objects.requireNonNull(builder.entity);
    }

    public static void handleRequest(RequestEntityPacket message, ServerPayloadContext context, Consumer<CompoundTag> responseSender) {
        ServerPlayer player = context.player();
        context.execute(() -> {
            EntityAccessor accessor = message.data().unpack(player);
            if (accessor == null) {
                return;
            }
            Entity entity = accessor.getEntity();
            double maxDistance = Mth.square((double)(player.entityInteractionRange() + 21.0));
            if (player.distanceToSqr(entity) > maxDistance) {
                return;
            }
            List<IServerDataProvider<EntityAccessor>> providers = WailaCommonRegistration.instance().entityDataProvidersOf(entity);
            CompoundTag tag = accessor.getServerData();
            for (IServerDataProvider<EntityAccessor> provider : providers) {
                if (!message.dataProviders().contains(provider)) continue;
                try {
                    provider.appendServerData(tag, accessor);
                }
                catch (Exception e) {
                    WailaExceptionHandler.handleErr(e, provider, null);
                }
            }
            tag.putInt("EntityId", entity.getId());
            responseSender.accept(tag);
        });
    }

    @Override
    public Entity getEntity() {
        return CommonProxy.wrapPartEntityParent(this.getRawEntity());
    }

    @Override
    public Entity getRawEntity() {
        return this.entity.get();
    }

    @Override
    public ItemStack getPickedResult() {
        if (this.isServersideContent()) {
            return this.getServersideRep();
        }
        return CommonProxy.getEntityPickedResult(this.entity.get(), this.getPlayer(), (EntityHitResult)this.getHitResult());
    }

    @Override
    public Object getTarget() {
        return this.getEntity();
    }

    @Override
    public boolean verifyData(CompoundTag data) {
        if (!this.verify) {
            return true;
        }
        return data.getInt("EntityId").filter(id -> id.intValue() == this.getEntity().getId()).isPresent();
    }

    public static class Builder
    implements EntityAccessor.Builder {
        public boolean showDetails;
        private @Nullable Level level;
        private @Nullable Player player;
        private @Nullable CompoundTag serverData;
        private boolean connected;
        private @Nullable Supplier<EntityHitResult> hit;
        private @Nullable Supplier<Entity> entity;
        private boolean verify;

        @Override
        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(Player player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(@Nullable CompoundTag serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(Supplier<EntityHitResult> hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder entity(Supplier<Entity> entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder from(EntityAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData().copy();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = accessor::getHitResult;
            this.entity = accessor::getEntity;
            this.verify = accessor.shouldVerifyData();
            return this;
        }

        @Override
        public EntityAccessor.Builder requireVerification(boolean verify) {
            this.verify = verify;
            return this;
        }

        @Override
        public EntityAccessor build() {
            EntityAccessorImpl accessor = new EntityAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }

    public record SyncData(boolean showDetails, int id, int partIndex, Vec3 hitVec, CompoundTag data) {
        public static final StreamCodec<RegistryFriendlyByteBuf, SyncData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SyncData::showDetails, (StreamCodec)ByteBufCodecs.VAR_INT, SyncData::id, (StreamCodec)ByteBufCodecs.VAR_INT, SyncData::partIndex, (StreamCodec)ByteBufCodecs.VECTOR3F.map(Vec3::new, Vec3::toVector3f), SyncData::hitVec, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, SyncData::data, SyncData::new);

        public SyncData(EntityAccessor accessor) {
            this(accessor.showDetails(), accessor.getEntity().getId(), CommonProxy.getPartEntityIndex(accessor.getRawEntity()), ((EntityHitResult)accessor.getHitResult()).getLocation(), accessor.getServerData());
        }

        public @Nullable EntityAccessor unpack(ServerPlayer player) {
            Entity entity = CommonProxy.getPartEntity(player.level().getEntity(this.id), this.partIndex);
            if (entity == null) {
                return null;
            }
            return ((Builder)((Builder)new Builder().level((Level)player.level()).player((Player)player).showDetails(this.showDetails).entity(() -> entity)).hit((Supplier)Suppliers.memoize(() -> new EntityHitResult(entity, this.hitVec)))).serverData(this.data).build();
        }
    }
}

