/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.TargetOperationRepository;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ProgressView;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.config.TargetOperationRepositoryImpl;
import snownee.jade.impl.lookup.HierarchyLookup;
import snownee.jade.impl.lookup.PairHierarchyLookup;
import snownee.jade.impl.lookup.WrappedHierarchyLookup;
import snownee.jade.util.CommonProxy;

public class WailaCommonRegistration
implements IWailaCommonRegistration {
    private static WailaCommonRegistration INSTANCE = new WailaCommonRegistration();
    public final PairHierarchyLookup<IServerDataProvider<BlockAccessor>> blockDataProviders = new PairHierarchyLookup(new HierarchyLookup(Block.class), new HierarchyLookup(BlockEntity.class));
    public final HierarchyLookup<IServerDataProvider<EntityAccessor>> entityDataProviders;
    public final PriorityStore<Identifier, IJadeProvider> priorities;
    public final WrappedHierarchyLookup<IServerExtensionProvider<ItemStack>> itemStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<FluidView.Data>> fluidStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<EnergyView.Data>> energyStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<ProgressView.Data>> progressProviders;
    private final TargetOperationRepositoryImpl<Block, BlockState> blockOperations;
    private final TargetOperationRepositoryImpl<EntityType<?>, Entity> entityTypeOperations;
    private final TargetOperationRepositoryImpl<MobEffect, MobEffectInstance> mobEffectOperations;

    WailaCommonRegistration() {
        this.blockDataProviders.idMapped();
        this.entityDataProviders = new HierarchyLookup(Entity.class);
        this.entityDataProviders.idMapped();
        this.priorities = new PriorityStore<Identifier, IJadeProvider>(IJadeProvider::getDefaultPriority, IJadeProvider::getUid);
        this.priorities.setSortingFunction((store, allKeys) -> {
            List keys = allKeys.stream().filter(IPluginConfig::isPrimaryKey).sorted(Comparator.comparingInt(store::byKey)).collect(Collectors.toCollection(ArrayList::new));
            allKeys.stream().filter(Predicate.not(IPluginConfig::isPrimaryKey)).forEach($ -> {
                int index = keys.indexOf(IPluginConfig.getPrimaryKey($));
                keys.add(index + 1, $);
            });
            return keys;
        });
        this.priorities.configurable("jade/sort-order", (Codec<Identifier>)Identifier.CODEC);
        this.itemStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.fluidStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.energyStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.progressProviders = WrappedHierarchyLookup.forAccessor();
        this.blockOperations = new TargetOperationRepositoryImpl(Registries.BLOCK, $ -> (ResourceKey)$.getBlockHolder().unwrapKey().orElseThrow(), "hide-blocks", () -> CommonProxy.isPhysicallyClient() ? List.of("barrier") : List.of());
        this.entityTypeOperations = new TargetOperationRepositoryImpl(Registries.ENTITY_TYPE, $ -> $.getType().builtInRegistryHolder().key(), "hide-entities", () -> CommonProxy.isPhysicallyClient() ? List.of("area_effect_cloud", "firework_rocket", "interaction", "text_display", "lightning_bolt") : List.of());
        this.mobEffectOperations = new TargetOperationRepositoryImpl(Registries.MOB_EFFECT, $ -> (ResourceKey)$.getEffect().unwrapKey().orElseThrow(), "hide-mob-effects", List::of);
    }

    public static WailaCommonRegistration instance() {
        return INSTANCE;
    }

    public static void reset() {
        INSTANCE = new WailaCommonRegistration();
    }

    @Override
    public void registerBlockDataProvider(IServerDataProvider<BlockAccessor> dataProvider, Class<?> blockOrBlobkEntityClass) {
        WailaCommonRegistration.checkDataProvider(dataProvider);
        this.blockDataProviders.register(blockOrBlobkEntityClass, dataProvider);
    }

    @Override
    public void registerEntityDataProvider(IServerDataProvider<EntityAccessor> dataProvider, Class<? extends Entity> entityClass) {
        WailaCommonRegistration.checkDataProvider(dataProvider);
        this.entityDataProviders.register(entityClass, dataProvider);
    }

    private static void checkDataProvider(IServerDataProvider<?> dataProvider) {
        if (CommonProxy.isPhysicallyClient() && dataProvider instanceof IComponentProvider) {
            throw new IllegalArgumentException("Data providers cannot implement IComponentProvider since Minecraft 1.21.6. Use a separate client provider instead.");
        }
    }

    public List<IServerDataProvider<BlockAccessor>> blockDataProvidersOf(BlockState blockState, @Nullable BlockEntity blockEntity, boolean checkIsHidden) {
        if (checkIsHidden && this.blockOperations().shouldHide(blockState)) {
            return List.of();
        }
        if (blockEntity == null) {
            return this.blockDataProviders.first.get(blockState.getBlock());
        }
        return this.blockDataProviders.getMerged(blockState.getBlock(), blockEntity);
    }

    public List<IServerDataProvider<EntityAccessor>> entityDataProvidersOf(Entity entity) {
        if (this.entityTypeOperations().shouldHide(entity)) {
            return List.of();
        }
        return this.entityDataProviders.get(entity);
    }

    public void loadComplete() {
        this.blockDataProviders.loadComplete(this.priorities);
        this.entityDataProviders.loadComplete(this.priorities);
        this.itemStorageProviders.loadComplete(this.priorities);
        this.fluidStorageProviders.loadComplete(this.priorities);
        this.energyStorageProviders.loadComplete(this.priorities);
        this.progressProviders.loadComplete(this.priorities);
    }

    public void reloadOperations(HolderLookup.Provider provider) {
        this.blockOperations.reload(provider);
        this.entityTypeOperations.reload(provider);
        this.mobEffectOperations.reload(provider);
    }

    @Override
    public TargetOperationRepository<Block, BlockState> blockOperations() {
        return this.blockOperations;
    }

    @Override
    public TargetOperationRepository<EntityType<?>, Entity> entityTypeOperations() {
        return this.entityTypeOperations;
    }

    @Override
    public TargetOperationRepository<MobEffect, MobEffectInstance> mobEffectOperations() {
        return this.mobEffectOperations;
    }

    @Override
    public <T> void registerItemStorage(IServerExtensionProvider<ItemStack> provider, Class<? extends T> clazz) {
        this.itemStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerFluidStorage(IServerExtensionProvider<FluidView.Data> provider, Class<? extends T> clazz) {
        this.fluidStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerEnergyStorage(IServerExtensionProvider<EnergyView.Data> provider, Class<? extends T> clazz) {
        this.energyStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerProgress(IServerExtensionProvider<ProgressView.Data> provider, Class<? extends T> clazz) {
        this.progressProviders.register(clazz, provider);
    }
}

