/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Util;
import snownee.jade.Jade;
import snownee.jade.api.config.IgnoreList;
import snownee.jade.api.config.TargetOperationRepository;
import snownee.jade.impl.config.TargetOperation;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeCodecs;
import snownee.jade.util.JsonConfig;

public class TargetOperationRepositoryImpl<T, U>
implements TargetOperationRepository<T, U> {
    private final ResourceKey<? extends Registry<T>> registry;
    private final Function<U, ResourceKey<T>> mapper;
    private final String fileName;
    private final Supplier<List<String>> defaultValues;
    private final Map<ResourceKey<T>, TargetOperation> builtIn = Maps.newIdentityHashMap();
    private final Map<ResourceKey<T>, TargetOperation> operations = Maps.newIdentityHashMap();

    public TargetOperationRepositoryImpl(ResourceKey<? extends Registry<T>> registry, Function<U, ResourceKey<T>> mapper, String fileName, Supplier<List<String>> defaultValues) {
        this.registry = registry;
        this.mapper = mapper;
        this.fileName = fileName;
        this.defaultValues = defaultValues;
    }

    @Override
    public void reload(HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup lookup = provider.lookupOrThrow(this.registry);
        this.operations.clear();
        this.operations.putAll(this.builtIn);
        IgnoreList list = new JsonConfig<IgnoreList>("jade/" + this.fileName, JadeCodecs.ignoreList(), null, () -> (IgnoreList)Util.make((Object)new IgnoreList(), $ -> {
            $.values = this.defaultValues.get();
        })).get();
        ArrayList patterns = Lists.newArrayList();
        for (String value : list.values) {
            try {
                if (value.startsWith("/") && value.endsWith("/") && value.length() > 1) {
                    patterns.add(Pattern.compile(value.substring(1, value.length() - 1)));
                    continue;
                }
                ResourceKey key = ResourceKey.create(this.registry, (Identifier)Identifier.parse((String)value));
                Optional optional = lookup.get(key);
                if (optional.isPresent()) {
                    this.operations.put(((Holder.Reference)optional.get()).key(), TargetOperation.HIDE);
                    continue;
                }
                throw new IllegalArgumentException("Unknown id: " + value);
            }
            catch (Exception e) {
                Jade.LOGGER.error("Failed to parse ignore list entry: %s".formatted(value), (Throwable)e);
            }
        }
        if (!patterns.isEmpty()) {
            block3: for (ResourceKey key : lookup.listElementIds().toList()) {
                String s = key.identifier().toString();
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(s).find()) continue;
                    this.operations.put(key, TargetOperation.HIDE);
                    continue block3;
                }
            }
        }
    }

    @Override
    public boolean shouldHide(ResourceKey<T> key) {
        return this.operations.get(key) == TargetOperation.HIDE;
    }

    @Override
    public boolean shouldPick(ResourceKey<T> key) {
        return this.operations.get(key) == TargetOperation.PICK;
    }

    @Override
    public void hide(ResourceKey<T> key) {
        this.builtIn.put(Objects.requireNonNull(key), TargetOperation.HIDE);
    }

    @Override
    public void pick(ResourceKey<T> key) {
        if (!CommonProxy.isPhysicallyClient()) {
            return;
        }
        this.builtIn.put(Objects.requireNonNull(key), TargetOperation.PICK);
    }

    @Override
    public ResourceKey<T> map(U obj) {
        return this.mapper.apply(obj);
    }
}

