/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import org.jspecify.annotations.Nullable;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.track.HealthTrackInfo;

public class HealthElement
extends Element {
    private Gui.HeartType heartType;
    private final float maxHealth;
    private final float health;
    private final float absorption;
    private @Nullable String text;
    private int iconsPerLine = 1;
    private int lineCount = 1;
    private int iconCount = 1;
    private @Nullable HealthTrackInfo track;

    public HealthElement(Gui.HeartType heartType, float maxHealth, float health, float absorption) {
        this.heartType = heartType;
        this.maxHealth = maxHealth;
        this.health = health;
        this.absorption = absorption;
        IPluginConfig config = IWailaConfig.get().plugin();
        int iconCount = Mth.ceil((float)maxHealth) + Mth.ceil((float)absorption);
        if (iconCount > config.getInt(JadeIds.MC_ENTITY_HEALTH_MAX_FOR_RENDER)) {
            health += absorption;
            if (!config.get(JadeIds.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
                maxHealth = Mth.ceil((float)maxHealth);
                health = Mth.ceil((float)health);
            }
            if (absorption > 0.0f) {
                this.heartType = Gui.HeartType.ABSORBING;
            }
            this.text = String.format("%s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
        } else {
            int maxHeartsPerLine = config.getInt(JadeIds.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            this.iconCount = iconCount = Mth.ceil((float)((float)iconCount * 0.5f));
            this.iconsPerLine = Math.min(maxHeartsPerLine, iconCount);
            this.lineCount = Mth.ceil((float)((float)iconCount / (float)maxHeartsPerLine));
        }
        if (this.showText()) {
            this.width = DisplayHelper.font().width(this.text) + 10;
            this.height = 9;
        } else {
            this.width = 8 * this.iconsPerLine + 1;
            this.height = 5 + 4 * this.lineCount;
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float health;
        float lastHealth = health = this.health * 0.5f;
        float lastAbsorption = this.absorption;
        boolean blink = false;
        if (this.track == null && this.getTag() != null) {
            this.track = JadeClient.tickHandler().progressTracker.getOrCreate(this.getTag(), HealthTrackInfo.class, () -> new HealthTrackInfo(this.health, this.absorption));
        }
        if (this.track != null) {
            this.track.setHealth(this.health, this.absorption);
            this.track.update(Minecraft.getInstance().getDeltaTracker().getRealtimeDeltaTicks());
            lastHealth = this.track.getLastHealth() * 0.5f;
            lastAbsorption = this.track.getLastAbsorption();
            blink = this.track.isBlinking();
        }
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = this.lineCount * 4 - 4;
        Identifier containerSprite = Gui.HeartType.CONTAINER.getSprite(false, false, blink);
        for (int i = this.iconCount; i > 0; --i) {
            int xPos = this.getX() + xOffset;
            int yPos = this.getY() + yOffset;
            helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, containerSprite, xPos, yPos, 9, 9);
            boolean renderAbsorb = i > Mth.ceil((float)(this.maxHealth * 0.5f));
            Gui.HeartType curHeart = this.heartType;
            float curHealth = health;
            float curLastHealth = lastHealth;
            if (renderAbsorb) {
                curHeart = Gui.HeartType.ABSORBING;
                curHealth = ((float)Mth.ceil((float)this.maxHealth) + this.absorption) * 0.5f;
                curLastHealth = ((float)Mth.ceil((float)this.maxHealth) + lastAbsorption) * 0.5f;
            }
            if (i <= Mth.floor((float)curHealth)) {
                helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, curHeart.getSprite(false, false, false), xPos, yPos, 9, 9);
            }
            if ((float)i > curHealth) {
                if (i <= Mth.floor((float)curLastHealth)) {
                    helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, curHeart.getSprite(false, false, true), xPos, yPos, 9, 9);
                } else if ((float)i > curLastHealth && (float)i < curLastHealth + 1.0f) {
                    helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, curHeart.getSprite(false, true, true), xPos, yPos, 9, 9);
                }
                if ((float)i < curHealth + 1.0f) {
                    helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, curHeart.getSprite(false, true, false), xPos, yPos, 9, 9);
                }
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
        if (this.showText()) {
            helper.drawText(graphics, Objects.requireNonNull(this.text), (float)(this.getX() + 10), (float)(this.getY() + 1), IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    public Component getNarration() {
        return Component.translatable((String)"narration.jade.health", (Object[])new Object[]{Mth.ceil((float)this.health)});
    }

    public boolean showText() {
        return this.text != null;
    }
}

